/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.utils.collections.StringArrayMap;
import org.apache.felix.utils.resource.CapabilityImpl;
import org.apache.felix.utils.resource.RequirementImpl;
import org.apache.felix.utils.resource.ResourceImpl;
import org.apache.felix.utils.resource.SimpleFilter;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public final class ResourceBuilder {
    public static final String RESOLUTION_DYNAMIC = "dynamic";
    private static final char EOF = '\uffff';
    private static final int CLAUSE_START = 0;
    private static final int PARAMETER_START = 1;
    private static final int KEY = 2;
    private static final int DIRECTIVE_OR_TYPEDATTRIBUTE = 4;
    private static final int ARGUMENT = 8;
    private static final int VALUE = 16;
    private static final int CHAR = 1;
    private static final int DELIMITER = 2;
    private static final int STARTQUOTE = 4;
    private static final int ENDQUOTE = 8;
    private static final Map<String, String> DEFAULT_DIRECTIVES = Collections.singletonMap("effective", "active");

    private ResourceBuilder() {
    }

    public static ResourceImpl build(String uri, Map<String, String> headerMap) throws BundleException {
        return ResourceBuilder.build(new ResourceImpl(), uri, headerMap, false);
    }

    public static ResourceImpl build(String uri, Map<String, String> headerMap, boolean removeServiceRequirements) throws BundleException {
        return ResourceBuilder.build(new ResourceImpl(), uri, headerMap, removeServiceRequirements);
    }

    public static ResourceImpl build(ResourceImpl resource, String uri, Map<String, String> headerMap) throws BundleException {
        return ResourceBuilder.build(resource, uri, headerMap, false);
    }

    public static ResourceImpl build(ResourceImpl resource, String uri, Map<String, String> headerMap, boolean removeServiceRequirements) throws BundleException {
        try {
            return ResourceBuilder.doBuild(resource, uri, headerMap, removeServiceRequirements);
        }
        catch (Exception e) {
            throw new BundleException("Unable to build resource for " + uri + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private static ResourceImpl doBuild(ResourceImpl resource, String uri, Map<String, String> headerMap, boolean removeServiceRequirements) throws BundleException {
        List<ParsedHeaderClause> importServices;
        List<Requirement> reqs;
        ParsedHeaderClause bundleCap;
        String manifestVersion = ResourceBuilder.getManifestVersion(headerMap);
        if (manifestVersion == null || !manifestVersion.equals("2")) {
            throw new BundleException("Unsupported 'Bundle-ManifestVersion' value: " + manifestVersion);
        }
        Version bundleVersion = Version.emptyVersion;
        if (headerMap.get("Bundle-Version") != null) {
            bundleVersion = VersionTable.getVersion(headerMap.get("Bundle-Version"));
        }
        if ((bundleCap = ResourceBuilder.parseBundleSymbolicName(headerMap)) == null) {
            throw new BundleException("Bundle manifest must include bundle symbolic name");
        }
        String bundleSymbolicName = (String)bundleCap.attrs.get("osgi.wiring.bundle");
        String type = headerMap.get("Fragment-Host") == null ? "osgi.bundle" : "osgi.fragment";
        StringArrayMap<Object> attrs = new StringArrayMap<Object>(3);
        attrs.put("osgi.identity", (Object)bundleSymbolicName);
        attrs.put("type", (Object)type);
        attrs.put("version", (Object)bundleVersion);
        CapabilityImpl identity = new CapabilityImpl(resource, "osgi.identity", Collections.emptyMap(), attrs);
        resource.addCapability(identity);
        if (uri != null) {
            resource.addCapability(new CapabilityImpl(resource, "osgi.content", Collections.emptyMap(), Collections.singletonMap("url", uri)));
        }
        if (headerMap.get("Fragment-Host") == null) {
            resource.addCapability(new CapabilityImpl(resource, "osgi.wiring.bundle", bundleCap.dirs, bundleCap.attrs));
            String attachment = bundleCap.dirs.get("fragment-attachment");
            String string = attachment = attachment == null ? "resolve-time" : attachment;
            if (!attachment.equalsIgnoreCase("never")) {
                StringArrayMap<Object> hostAttrs = new StringArrayMap<Object>(bundleCap.attrs.size());
                for (Map.Entry<String, Object> e : bundleCap.attrs.entrySet()) {
                    String k = e.getKey();
                    if ("osgi.wiring.bundle".equals(k)) {
                        k = "osgi.wiring.host";
                    }
                    hostAttrs.put(k, e.getValue());
                }
                resource.addCapability(new CapabilityImpl(resource, "osgi.wiring.host", bundleCap.dirs, hostAttrs));
            }
        }
        List<RequirementImpl> hostReqs = ResourceBuilder.parseFragmentHost(resource, headerMap);
        List<ParsedHeaderClause> rbClauses = ResourceBuilder.parseStandardHeader(headerMap.get("Require-Bundle"));
        rbClauses = ResourceBuilder.normalizeRequireClauses(rbClauses);
        List<Requirement> rbReqs = ResourceBuilder.convertRequires(rbClauses, resource);
        List<ParsedHeaderClause> importClauses = ResourceBuilder.parseStandardHeader(headerMap.get("Import-Package"));
        importClauses = ResourceBuilder.normalizeImportClauses(importClauses);
        List<Requirement> importReqs = ResourceBuilder.convertImports(importClauses, resource);
        List<ParsedHeaderClause> dynamicClauses = ResourceBuilder.parseStandardHeader(headerMap.get("DynamicImport-Package"));
        dynamicClauses = ResourceBuilder.normalizeDynamicImportClauses(dynamicClauses);
        List<Requirement> dynamicReqs = ResourceBuilder.convertImports(dynamicClauses, resource);
        List<ParsedHeaderClause> requireClauses = ResourceBuilder.parseStandardHeader(headerMap.get("Require-Capability"));
        requireClauses = ResourceBuilder.normalizeRequireCapabilityClauses(requireClauses);
        List<Requirement> requireReqs = ResourceBuilder.convertRequireCapabilities(requireClauses, resource);
        List<Requirement> breeReqs = ResourceBuilder.parseBreeHeader(headerMap.get("Bundle-RequiredExecutionEnvironment"), resource);
        List<ParsedHeaderClause> exportClauses = ResourceBuilder.parseStandardHeader(headerMap.get("Export-Package"));
        exportClauses = ResourceBuilder.normalizeExportClauses(exportClauses, bundleSymbolicName, bundleVersion);
        List<Capability> exportCaps = ResourceBuilder.convertExports(exportClauses, resource);
        List<ParsedHeaderClause> provideClauses = ResourceBuilder.parseStandardHeader(headerMap.get("Provide-Capability"));
        provideClauses = ResourceBuilder.normalizeProvideCapabilityClauses(provideClauses);
        List<Capability> provideCaps = ResourceBuilder.convertProvideCapabilities(provideClauses, resource);
        boolean hasServiceReferenceCapability = false;
        for (Capability cap : exportCaps) {
            hasServiceReferenceCapability |= "osgi.service".equals(cap.getNamespace());
        }
        if (!hasServiceReferenceCapability) {
            List<ParsedHeaderClause> exportServices = ResourceBuilder.parseStandardHeader(headerMap.get("Export-Service"));
            List<Capability> caps = ResourceBuilder.convertExportService(exportServices, resource);
            provideCaps.addAll((Collection<Capability>)caps);
        }
        boolean hasServiceReferenceRequirement = false;
        for (Requirement req : requireReqs) {
            hasServiceReferenceRequirement |= "osgi.service".equals(req.getNamespace());
        }
        if (!hasServiceReferenceRequirement && !(reqs = ResourceBuilder.convertImportService(importServices = ResourceBuilder.parseStandardHeader(headerMap.get("Import-Service")), resource)).isEmpty()) {
            requireReqs.addAll(reqs);
            hasServiceReferenceRequirement = true;
        }
        if (hasServiceReferenceRequirement && removeServiceRequirements) {
            Iterator<Requirement> iterator = requireReqs.iterator();
            while (iterator.hasNext()) {
                Requirement req;
                req = iterator.next();
                if (!"osgi.service".equals(req.getNamespace())) continue;
                iterator.remove();
            }
        }
        resource.addCapabilities(exportCaps);
        resource.addCapabilities(provideCaps);
        resource.addRequirements(hostReqs);
        resource.addRequirements(importReqs);
        resource.addRequirements(rbReqs);
        resource.addRequirements(requireReqs);
        resource.addRequirements(dynamicReqs);
        return resource;
    }

    public static List<Requirement> parseRequirement(Resource resource, String requirement) throws BundleException {
        List<ParsedHeaderClause> requireClauses = ResourceBuilder.parseStandardHeader(requirement);
        requireClauses = ResourceBuilder.normalizeRequireCapabilityClauses(requireClauses);
        return ResourceBuilder.convertRequireCapabilities(requireClauses, resource);
    }

    public static List<Capability> parseCapability(Resource resource, String capability) throws BundleException {
        List<ParsedHeaderClause> provideClauses = ResourceBuilder.parseStandardHeader(capability);
        provideClauses = ResourceBuilder.normalizeProvideCapabilityClauses(provideClauses);
        return ResourceBuilder.convertProvideCapabilities(provideClauses, resource);
    }

    private static List<ParsedHeaderClause> normalizeImportClauses(List<ParsedHeaderClause> clauses) throws BundleException {
        HashSet<String> dupeSet = new HashSet<String>();
        for (ParsedHeaderClause clause : clauses) {
            Object v = clause.attrs.get("version");
            Object sv = clause.attrs.get("specification-version");
            if (v != null && sv != null && !((String)v).trim().equals(((String)sv).trim())) {
                throw new IllegalArgumentException("Both version and specification-version are specified, but they are not equal.");
            }
            if (v != null || sv != null) {
                clause.attrs.remove("specification-version");
                v = v == null ? sv : v;
                clause.attrs.put("version", VersionRange.parseVersionRange(v.toString()));
            }
            if ((v = clause.attrs.get("bundle-version")) != null) {
                clause.attrs.put("bundle-version", VersionRange.parseVersionRange(v.toString()));
            }
            for (String pkgName : clause.paths) {
                if (!dupeSet.contains(pkgName)) {
                    if (pkgName.equals(".")) {
                        throw new BundleException("Importing '.' is invalid.");
                    }
                    if (pkgName.length() == 0) {
                        throw new BundleException("Imported package names cannot be zero length.");
                    }
                    dupeSet.add(pkgName);
                    continue;
                }
                throw new BundleException("Duplicate import: " + pkgName);
            }
        }
        return clauses;
    }

    private static List<Capability> convertExportService(List<ParsedHeaderClause> clauses, Resource resource) {
        ArrayList<Capability> capList = new ArrayList<Capability>();
        for (ParsedHeaderClause clause : clauses) {
            for (String path : clause.paths) {
                LinkedHashMap<String, Object> attrs = new LinkedHashMap<String, Object>();
                attrs.put("objectClass", path);
                attrs.putAll(clause.attrs);
                capList.add(new CapabilityImpl(resource, "osgi.service", DEFAULT_DIRECTIVES, attrs));
            }
        }
        return capList;
    }

    private static List<Requirement> convertImportService(List<ParsedHeaderClause> clauses, Resource resource) throws BundleException {
        try {
            ArrayList<Requirement> reqList = new ArrayList<Requirement>();
            for (ParsedHeaderClause clause : clauses) {
                for (String path : clause.paths) {
                    String multiple = clause.dirs.get("multiple");
                    String avail = clause.dirs.get("availability");
                    String filter = (String)clause.attrs.get("filter");
                    LinkedHashMap<String, String> dirs = new LinkedHashMap<String, String>(2);
                    dirs.put("effective", "active");
                    if ("optional".equals(avail)) {
                        dirs.put("resolution", "optional");
                    }
                    if ("true".equals(multiple)) {
                        dirs.put("cardinality", "multiple");
                    }
                    filter = filter == null ? "(objectClass=" + path + ")" : (!filter.startsWith("(") && !filter.endsWith(")") ? "(&(objectClass=" + path + ")(" + filter + "))" : "(&(objectClass=" + path + ")" + filter + ")");
                    dirs.put("filter", filter);
                    reqList.add(new RequirementImpl(resource, "osgi.service", dirs, null, SimpleFilter.parse(filter)));
                }
            }
            return reqList;
        }
        catch (Exception ex) {
            throw new BundleException("Error creating requirement: " + ex, (Throwable)ex);
        }
    }

    private static List<Requirement> convertImports(List<ParsedHeaderClause> clauses, Resource resource) {
        ArrayList<Requirement> reqList = new ArrayList<Requirement>();
        for (ParsedHeaderClause clause : clauses) {
            for (String path : clause.paths) {
                Map<String, Object> attrs = clause.attrs;
                LinkedHashMap<String, Object> newAttrs = new LinkedHashMap<String, Object>(attrs.size() + 1);
                newAttrs.put("osgi.wiring.package", path);
                newAttrs.putAll(attrs);
                newAttrs.put("osgi.wiring.package", path);
                SimpleFilter sf = SimpleFilter.convert(newAttrs);
                Map<String, String> dirs = clause.dirs;
                StringArrayMap<String> newDirs = new StringArrayMap<String>(dirs.size() + 1);
                newDirs.putAll(dirs);
                newDirs.put("filter", sf.toString());
                reqList.add(new RequirementImpl(resource, "osgi.wiring.package", newDirs, null, sf));
            }
        }
        return reqList;
    }

    private static List<ParsedHeaderClause> normalizeDynamicImportClauses(List<ParsedHeaderClause> clauses) throws BundleException {
        for (ParsedHeaderClause clause : clauses) {
            clause.dirs.put("resolution", RESOLUTION_DYNAMIC);
            Object v = clause.attrs.get("version");
            Object sv = clause.attrs.get("specification-version");
            if (v != null && sv != null && !((String)v).trim().equals(((String)sv).trim())) {
                throw new IllegalArgumentException("Both version and specification-version are specified, but they are not equal.");
            }
            if (v != null || sv != null) {
                clause.attrs.remove("specification-version");
                v = v == null ? sv : v;
                clause.attrs.put("version", VersionRange.parseVersionRange(v.toString()));
            }
            if ((v = clause.attrs.get("bundle-version")) != null) {
                clause.attrs.put("bundle-version", VersionRange.parseVersionRange(v.toString()));
            }
            for (String pkgName : clause.paths) {
                if (pkgName.startsWith("java.")) {
                    throw new BundleException("Dynamically importing java.* packages not allowed: " + pkgName);
                }
                if (pkgName.equals("*") || !pkgName.endsWith("*") || pkgName.endsWith(".*")) continue;
                throw new BundleException("Partial package name wild carding is not allowed: " + pkgName);
            }
        }
        return clauses;
    }

    private static List<ParsedHeaderClause> normalizeRequireCapabilityClauses(List<ParsedHeaderClause> clauses) throws BundleException {
        for (ParsedHeaderClause clause : clauses) {
            for (Map.Entry<String, Object> entry : clause.attrs.entrySet()) {
                if (!entry.getKey().equals("version")) continue;
                clause.attrs.put(entry.getKey(), new VersionRange(entry.getValue().toString()));
            }
            for (Map.Entry<String, Object> entry : clause.types.entrySet()) {
                String type = (String)entry.getValue();
                if (type.equals("String")) continue;
                if (type.equals("Double")) {
                    clause.attrs.put(entry.getKey(), new Double(clause.attrs.get(entry.getKey()).toString().trim()));
                    continue;
                }
                if (type.equals("Version")) {
                    clause.attrs.put(entry.getKey(), new Version(clause.attrs.get(entry.getKey()).toString().trim()));
                    continue;
                }
                if (type.equals("Long")) {
                    clause.attrs.put(entry.getKey(), new Long(clause.attrs.get(entry.getKey()).toString().trim()));
                    continue;
                }
                if (type.startsWith("List")) {
                    int startIdx = type.indexOf(60);
                    int endIdx = type.indexOf(62);
                    if (startIdx > 0 && endIdx <= startIdx || startIdx < 0 && endIdx > 0) {
                        throw new BundleException("Invalid Provide-Capability attribute list type for '" + entry.getKey() + "' : " + type);
                    }
                    String listType = "String";
                    if (endIdx > startIdx) {
                        listType = type.substring(startIdx + 1, endIdx).trim();
                    }
                    List<String> tokens = ResourceBuilder.parseDelimitedString(clause.attrs.get(entry.getKey()).toString(), ",", false);
                    ArrayList<Object> values = new ArrayList<Object>(tokens.size());
                    block15: for (String token : tokens) {
                        switch (listType) {
                            case "String": {
                                values.add(token);
                                continue block15;
                            }
                            case "Double": {
                                values.add(new Double(token.trim()));
                                continue block15;
                            }
                            case "Version": {
                                values.add(new Version(token.trim()));
                                continue block15;
                            }
                            case "Long": {
                                values.add(new Long(token.trim()));
                                continue block15;
                            }
                        }
                        throw new BundleException("Unknown Provide-Capability attribute list type for '" + entry.getKey() + "' : " + type);
                    }
                    clause.attrs.put(entry.getKey(), values);
                    continue;
                }
                throw new BundleException("Unknown Provide-Capability attribute type for '" + entry.getKey() + "' : " + type);
            }
        }
        return clauses;
    }

    private static List<ParsedHeaderClause> normalizeProvideCapabilityClauses(List<ParsedHeaderClause> clauses) throws BundleException {
        for (ParsedHeaderClause clause : clauses) {
            for (Map.Entry<String, String> entry : clause.types.entrySet()) {
                String type = entry.getValue();
                if (type.equals("String")) continue;
                if (type.equals("Double")) {
                    clause.attrs.put(entry.getKey(), new Double(clause.attrs.get(entry.getKey()).toString().trim()));
                    continue;
                }
                if (type.equals("Version")) {
                    clause.attrs.put(entry.getKey(), new Version(clause.attrs.get(entry.getKey()).toString().trim()));
                    continue;
                }
                if (type.equals("Long")) {
                    clause.attrs.put(entry.getKey(), new Long(clause.attrs.get(entry.getKey()).toString().trim()));
                    continue;
                }
                if (type.startsWith("List")) {
                    int startIdx = type.indexOf(60);
                    int endIdx = type.indexOf(62);
                    if (startIdx > 0 && endIdx <= startIdx || startIdx < 0 && endIdx > 0) {
                        throw new BundleException("Invalid Provide-Capability attribute list type for '" + entry.getKey() + "' : " + type);
                    }
                    String listType = "String";
                    if (endIdx > startIdx) {
                        listType = type.substring(startIdx + 1, endIdx).trim();
                    }
                    List<String> tokens = ResourceBuilder.parseDelimitedString(clause.attrs.get(entry.getKey()).toString(), ",", false);
                    ArrayList<Object> values = new ArrayList<Object>(tokens.size());
                    block14: for (String token : tokens) {
                        switch (listType) {
                            case "String": {
                                values.add(token);
                                continue block14;
                            }
                            case "Double": {
                                values.add(new Double(token.trim()));
                                continue block14;
                            }
                            case "Version": {
                                values.add(new Version(token.trim()));
                                continue block14;
                            }
                            case "Long": {
                                values.add(new Long(token.trim()));
                                continue block14;
                            }
                        }
                        throw new BundleException("Unknown Provide-Capability attribute list type for '" + entry.getKey() + "' : " + type);
                    }
                    clause.attrs.put(entry.getKey(), values);
                    continue;
                }
                throw new BundleException("Unknown Provide-Capability attribute type for '" + entry.getKey() + "' : " + type);
            }
        }
        return clauses;
    }

    private static List<Requirement> convertRequireCapabilities(List<ParsedHeaderClause> clauses, Resource resource) throws BundleException {
        ArrayList<Requirement> reqList = new ArrayList<Requirement>();
        for (ParsedHeaderClause clause : clauses) {
            try {
                String filterStr = clause.dirs.get("filter");
                SimpleFilter sf = filterStr != null ? SimpleFilter.parse(filterStr) : SimpleFilter.convert(clause.attrs);
                for (String path : clause.paths) {
                    reqList.add(new RequirementImpl(resource, path, clause.dirs, clause.attrs, sf));
                }
            }
            catch (Exception ex) {
                throw new BundleException("Error creating requirement: " + ex, (Throwable)ex);
            }
        }
        return reqList;
    }

    private static List<Capability> convertProvideCapabilities(List<ParsedHeaderClause> clauses, Resource resource) throws BundleException {
        ArrayList<Capability> capList = new ArrayList<Capability>();
        for (ParsedHeaderClause clause : clauses) {
            for (String path : clause.paths) {
                if (path.startsWith("osgi.wiring.")) {
                    // empty if block
                }
                capList.add(new CapabilityImpl(resource, path, clause.dirs, clause.attrs));
            }
        }
        return capList;
    }

    private static List<ParsedHeaderClause> normalizeExportClauses(List<ParsedHeaderClause> clauses, String bsn, Version bv) throws BundleException {
        for (ParsedHeaderClause clause : clauses) {
            for (String pkgName : clause.paths) {
                if (pkgName.equals(".")) {
                    throw new BundleException("Exporting '.' is invalid.");
                }
                if (pkgName.length() != 0) continue;
                throw new BundleException("Exported package names cannot be zero length.");
            }
            Object v = clause.attrs.get("version");
            Object sv = clause.attrs.get("specification-version");
            if (v != null && sv != null && !((String)v).trim().equals(((String)sv).trim())) {
                throw new IllegalArgumentException("Both version and specification-version are specified, but they are not equal.");
            }
            if (v == null && sv == null) {
                v = Version.emptyVersion;
            }
            if (v != null || sv != null) {
                clause.attrs.remove("specification-version");
                v = v == null ? sv : v;
                clause.attrs.put("version", VersionTable.getVersion(v.toString()));
            }
            if (clause.attrs.containsKey("bundle-version") || clause.attrs.containsKey("bundle-symbolic-name")) {
                throw new BundleException("Exports must not specify bundle symbolic name or bundle version.");
            }
            clause.attrs.put("bundle-symbolic-name", bsn);
            clause.attrs.put("bundle-version", bv);
        }
        return clauses;
    }

    private static List<Capability> convertExports(List<ParsedHeaderClause> clauses, Resource resource) {
        ArrayList<Capability> capList = new ArrayList<Capability>();
        for (ParsedHeaderClause clause : clauses) {
            for (String pkgName : clause.paths) {
                Map<String, Object> attrs = clause.attrs;
                StringArrayMap<Object> newAttrs = new StringArrayMap<Object>(attrs.size() + 1);
                newAttrs.putAll(attrs);
                newAttrs.put("osgi.wiring.package", (Object)pkgName);
                capList.add(new CapabilityImpl(resource, "osgi.wiring.package", clause.dirs, newAttrs));
            }
        }
        return capList;
    }

    private static String getManifestVersion(Map<String, String> headerMap) {
        String manifestVersion = headerMap.get("Bundle-ManifestVersion");
        return manifestVersion == null ? "1" : manifestVersion.trim();
    }

    private static ParsedHeaderClause parseBundleSymbolicName(Map<String, String> headerMap) throws BundleException {
        List<ParsedHeaderClause> clauses = ResourceBuilder.parseStandardHeader(headerMap.get("Bundle-SymbolicName"));
        if (clauses.size() > 0) {
            if (clauses.size() > 1 || clauses.get((int)0).paths.size() > 1) {
                throw new BundleException("Cannot have multiple symbolic names: " + headerMap.get("Bundle-SymbolicName"));
            }
            Version bundleVersion = Version.emptyVersion;
            if (headerMap.get("Bundle-Version") != null) {
                bundleVersion = VersionTable.getVersion(headerMap.get("Bundle-Version"));
            }
            ParsedHeaderClause clause = clauses.get(0);
            String symName = clause.paths.get(0);
            clause.attrs.put("osgi.wiring.bundle", symName);
            clause.attrs.put("bundle-version", bundleVersion);
            return clause;
        }
        return null;
    }

    private static List<RequirementImpl> parseFragmentHost(Resource resource, Map<String, String> headerMap) throws BundleException {
        ArrayList<RequirementImpl> reqs = new ArrayList<RequirementImpl>();
        List<ParsedHeaderClause> clauses = ResourceBuilder.parseStandardHeader(headerMap.get("Fragment-Host"));
        if (clauses.size() > 0) {
            if (clauses.size() > 1 || clauses.get((int)0).paths.size() > 1) {
                throw new BundleException("Fragments cannot have multiple hosts: " + headerMap.get("Fragment-Host"));
            }
            Object value = clauses.get((int)0).attrs.get("bundle-version");
            value = value == null ? "0.0.0" : value;
            clauses.get((int)0).attrs.put("bundle-version", VersionRange.parseVersionRange(value.toString()));
            Map<String, Object> attrs = clauses.get((int)0).attrs;
            LinkedHashMap<String, Object> newAttrs = new LinkedHashMap<String, Object>(attrs.size() + 1);
            newAttrs.put("osgi.wiring.host", clauses.get((int)0).paths.get(0));
            newAttrs.putAll(attrs);
            newAttrs.put("osgi.wiring.host", clauses.get((int)0).paths.get(0));
            SimpleFilter sf = SimpleFilter.convert(newAttrs);
            Map<String, String> dirs = clauses.get((int)0).dirs;
            StringArrayMap<String> newDirs = new StringArrayMap<String>(dirs.size() + 1);
            newDirs.putAll(dirs);
            newDirs.put("filter", sf.toString());
            reqs.add(new RequirementImpl(resource, "osgi.wiring.host", newDirs, newAttrs));
        }
        return reqs;
    }

    private static List<Requirement> parseBreeHeader(String header, Resource resource) {
        String reqFilter;
        ArrayList<String> filters = new ArrayList<String>();
        for (String entry : ResourceBuilder.parseDelimitedString(header, ",")) {
            String versionClause;
            Version lVer;
            List<String> names = ResourceBuilder.parseDelimitedString(entry, "/");
            List<String> left = ResourceBuilder.parseDelimitedString(names.get(0), "-");
            String lName = left.get(0);
            try {
                lVer = Version.parseVersion((String)left.get(1));
            }
            catch (Exception ex) {
                lName = names.get(0);
                lVer = null;
            }
            String rName = null;
            Version rVer = null;
            if (names.size() > 1) {
                List<String> right = ResourceBuilder.parseDelimitedString(names.get(1), "-");
                rName = right.get(0);
                try {
                    rVer = Version.parseVersion((String)right.get(1));
                }
                catch (Exception ex) {
                    rName = names.get(1);
                    rVer = null;
                }
            }
            if (lVer != null) {
                if (rVer != null && !rVer.equals((Object)lVer)) {
                    lName = names.get(0);
                    rName = names.get(1);
                    versionClause = null;
                } else {
                    versionClause = ResourceBuilder.getBreeVersionClause(lVer);
                }
            } else {
                versionClause = ResourceBuilder.getBreeVersionClause(rVer);
            }
            if ("J2SE".equals(lName)) {
                lName = "JavaSE";
            }
            String nameClause = rName != null ? "(osgi.ee=" + lName + "/" + rName + ")" : "(osgi.ee=" + lName + ")";
            String filter = versionClause != null ? "(&" + nameClause + versionClause + ")" : nameClause;
            filters.add(filter);
        }
        if (filters.size() == 0) {
            return Collections.emptyList();
        }
        if (filters.size() == 1) {
            reqFilter = (String)filters.get(0);
        } else {
            StringBuilder sb = new StringBuilder("(|");
            for (String f : filters) {
                sb.append(f);
            }
            sb.append(")");
            reqFilter = sb.toString();
        }
        SimpleFilter sf = SimpleFilter.parse(reqFilter);
        return Collections.singletonList(new RequirementImpl(resource, "osgi.ee", Collections.singletonMap("filter", reqFilter), null, sf));
    }

    private static String getBreeVersionClause(Version ver) {
        if (ver == null) {
            return null;
        }
        return "(version=" + ver + ")";
    }

    private static List<ParsedHeaderClause> normalizeRequireClauses(List<ParsedHeaderClause> clauses) {
        for (ParsedHeaderClause clause : clauses) {
            Object value = clause.attrs.get("bundle-version");
            if (value == null) continue;
            clause.attrs.put("bundle-version", VersionRange.parseVersionRange(value.toString()));
        }
        return clauses;
    }

    private static List<Requirement> convertRequires(List<ParsedHeaderClause> clauses, Resource resource) {
        ArrayList<Requirement> reqList = new ArrayList<Requirement>();
        for (ParsedHeaderClause clause : clauses) {
            for (String path : clause.paths) {
                Map<String, Object> attrs = clause.attrs;
                LinkedHashMap<String, Object> newAttrs = new LinkedHashMap<String, Object>(attrs.size() + 1);
                newAttrs.put("osgi.wiring.bundle", path);
                newAttrs.putAll(attrs);
                newAttrs.put("osgi.wiring.bundle", path);
                SimpleFilter sf = SimpleFilter.convert(newAttrs);
                Map<String, String> dirs = clause.dirs;
                StringArrayMap<String> newDirs = new StringArrayMap<String>(dirs.size() + 1);
                newDirs.putAll(dirs);
                newDirs.put("filter", sf.toString());
                reqList.add(new RequirementImpl(resource, "osgi.wiring.bundle", newDirs, newAttrs));
            }
        }
        return reqList;
    }

    private static char charAt(int pos, String headers, int length) {
        if (pos >= length) {
            return '\uffff';
        }
        return headers.charAt(pos);
    }

    private static List<ParsedHeaderClause> parseStandardHeader(String header) {
        char currentChar;
        ArrayList<ParsedHeaderClause> clauses = new ArrayList<ParsedHeaderClause>();
        if (header == null) {
            return clauses;
        }
        ParsedHeaderClause clause = null;
        String key = null;
        Map<String, Object> targetMap = null;
        int state = 0;
        int currentPosition = 0;
        int startPosition = 0;
        int length = header.length();
        boolean quoted = false;
        boolean escaped = false;
        do {
            currentChar = ResourceBuilder.charAt(currentPosition, header, length);
            switch (state) {
                case 0: {
                    clause = new ParsedHeaderClause();
                    clauses.add(clause);
                }
                case 1: {
                    startPosition = currentPosition;
                    state = 2;
                }
                case 2: {
                    switch (currentChar) {
                        case ':': 
                        case '=': {
                            key = header.substring(startPosition, currentPosition).trim();
                            startPosition = currentPosition + 1;
                            targetMap = clause.attrs;
                            state = currentChar == ':' ? 4 : 8;
                            break;
                        }
                        case ',': 
                        case ';': 
                        case '\uffff': {
                            clause.paths.add(header.substring(startPosition, currentPosition).trim());
                            state = currentChar == ',' ? 0 : 1;
                            break;
                        }
                    }
                    ++currentPosition;
                    break;
                }
                case 4: {
                    switch (currentChar) {
                        case '=': {
                            if (startPosition != currentPosition) {
                                clause.types.put(key, header.substring(startPosition, currentPosition).trim());
                            } else {
                                targetMap = clause.dirs;
                            }
                            state = 8;
                            startPosition = currentPosition + 1;
                            break;
                        }
                    }
                    ++currentPosition;
                    break;
                }
                case 8: {
                    if (currentChar == '\"') {
                        quoted = true;
                        ++currentPosition;
                    } else {
                        quoted = false;
                    }
                    if (!Character.isWhitespace(currentChar)) {
                        state = 16;
                        break;
                    }
                    ++currentPosition;
                    break;
                }
                case 16: {
                    if (escaped) {
                        escaped = false;
                    } else if (currentChar == '\\') {
                        escaped = true;
                    } else if (quoted && currentChar == '\"') {
                        quoted = false;
                    } else if (!quoted) {
                        switch (currentChar) {
                            case ',': 
                            case ';': 
                            case '\uffff': {
                                String value = header.substring(startPosition, currentPosition).trim();
                                if (value.startsWith("\"") && value.endsWith("\"")) {
                                    value = value.substring(1, value.length() - 1);
                                }
                                if (targetMap.put(key, value) != null) {
                                    throw new IllegalArgumentException("Duplicate '" + key + "' in: " + header);
                                }
                                state = currentChar == ';' ? 1 : 0;
                                break;
                            }
                        }
                    }
                    ++currentPosition;
                    break;
                }
            }
        } while (currentChar != '\uffff');
        if (state > 1) {
            throw new IllegalArgumentException("Unable to parse header: " + header);
        }
        return clauses;
    }

    public static List<String> parseDelimitedString(String value, String delim) {
        return ResourceBuilder.parseDelimitedString(value, delim, true);
    }

    public static List<String> parseDelimitedString(String value, String delim, boolean trim) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int expecting = 7;
        boolean isEscaped = false;
        for (int i = 0; i < value.length(); ++i) {
            boolean isDelimiter;
            char c = value.charAt(i);
            boolean bl = isDelimiter = delim.indexOf(c) >= 0;
            if (!isEscaped && c == '\\') {
                isEscaped = true;
                continue;
            }
            if (isEscaped) {
                sb.append(c);
            } else if (isDelimiter && (expecting & 2) > 0) {
                if (trim) {
                    list.add(sb.toString().trim());
                } else {
                    list.add(sb.toString());
                }
                sb.delete(0, sb.length());
                expecting = 7;
            } else if (c == '\"' && (expecting & 4) > 0) {
                sb.append(c);
                expecting = 9;
            } else if (c == '\"' && (expecting & 8) > 0) {
                sb.append(c);
                expecting = 7;
            } else if ((expecting & 1) > 0) {
                sb.append(c);
            } else {
                throw new IllegalArgumentException("Invalid delimited string: " + value);
            }
            isEscaped = false;
        }
        if (sb.length() > 0) {
            if (trim) {
                list.add(sb.toString().trim());
            } else {
                list.add(sb.toString());
            }
        }
        return list;
    }

    static class ParsedHeaderClause {
        public final List<String> paths = new ArrayList<String>();
        public final Map<String, String> dirs = new StringArrayMap<String>(0);
        public final Map<String, Object> attrs = new StringArrayMap<Object>(0);
        public final Map<String, String> types = new StringArrayMap<String>(0);

        ParsedHeaderClause() {
        }
    }
}

