/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.nav.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.sling.ide.eclipse.ui.nav.model.SyncDir;
import org.apache.sling.ide.eclipse.ui.nav.model.UpdateHandler;
import org.eclipse.core.resources.IFolder;

public class SyncDirManager {
    private static Map<IFolder, SyncDir> syncDirs = new HashMap<IFolder, SyncDir>();
    private static List<UpdateHandler> handlers = new LinkedList<UpdateHandler>();

    public static void registerNewSyncDir(SyncDir syncDir) {
        syncDirs.put(syncDir.getFolder(), syncDir);
        SyncDirManager.syncDirChanged(syncDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncDirChanged(SyncDir syncDir) {
        ArrayList<UpdateHandler> handlersCopy;
        List<UpdateHandler> list = handlers;
        synchronized (list) {
            handlersCopy = new ArrayList<UpdateHandler>(handlers);
        }
        for (UpdateHandler updateHandler : handlersCopy) {
            updateHandler.syncDirUpdated(syncDir);
        }
    }

    public static SyncDir getSyncDirOrNull(IFolder folder) {
        return syncDirs.get(folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerUpdateListener(UpdateHandler updateHandler) {
        List<UpdateHandler> list = handlers;
        synchronized (list) {
            handlers.add(updateHandler);
        }
    }
}

