/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.dnd.assistant;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.SubContributionManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class StatusLineUtils {
    private static long statusModCnt = 0L;
    private static boolean isShowing = false;
    private static final Object syncObj = new Object();

    private static IStatusLineManager getStatusLineManager() {
        IWorkbenchPart activePart;
        IEditorReference[] editorRefs;
        int n;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor != null) {
            return activeEditor.getEditorSite().getActionBars().getStatusLineManager();
        }
        IViewReference[] viewRefs = activePage.getViewReferences();
        if (viewRefs != null) {
            IViewReference[] iViewReferenceArray = viewRefs;
            n = viewRefs.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference aViewRef = iViewReferenceArray[n2];
                IViewPart view = aViewRef.getView(false);
                if (view != null) {
                    return view.getViewSite().getActionBars().getStatusLineManager();
                }
                ++n2;
            }
        }
        if ((editorRefs = activePage.getEditorReferences()) != null) {
            IEditorReference[] iEditorReferenceArray = editorRefs;
            int n3 = editorRefs.length;
            n = 0;
            while (n < n3) {
                IEditorReference anEditorRef = iEditorReferenceArray[n];
                IEditorPart editor = anEditorRef.getEditor(false);
                if (editor != null) {
                    return editor.getEditorSite().getActionBars().getStatusLineManager();
                }
                ++n;
            }
        }
        if ((activePart = activePage.getActivePart()) == null) {
            return null;
        }
        IWorkbenchPartSite site = activePart.getSite();
        if (site instanceof IEditorSite) {
            IEditorSite editorSite = (IEditorSite)site;
            return editorSite.getActionBars().getStatusLineManager();
        }
        if (site instanceof IViewSite) {
            IViewSite viewSite = (IViewSite)site;
            return viewSite.getActionBars().getStatusLineManager();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetErrorMessage() {
        Object object = syncObj;
        synchronized (object) {
            if (!isShowing) {
                return;
            }
            isShowing = false;
        }
        StatusLineUtils.doSetErrorMessage(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setErrorMessage(int durationInMillis, String message) {
        long myModCnt;
        Object object = syncObj;
        synchronized (object) {
            myModCnt = ++statusModCnt;
            isShowing = true;
        }
        StatusLineUtils.doSetErrorMessage(message);
        Display.getDefault().timerExec(durationInMillis, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (statusModCnt > myModCnt) {
                    return;
                }
                Object object = syncObj;
                synchronized (object) {
                    if (!isShowing) {
                        return;
                    }
                    isShowing = false;
                }
                StatusLineUtils.doSetErrorMessage(null);
            }
        });
    }

    private static void doSetErrorMessage(final String message) {
        final IStatusLineManager statusLineManager = StatusLineUtils.getStatusLineManager();
        if (statusLineManager != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (statusLineManager instanceof SubContributionManager) {
                        SubContributionManager sub = (SubContributionManager)statusLineManager;
                        StatusLineManager parent = (StatusLineManager)sub.getParent();
                        parent.setErrorMessage(message);
                        parent.update(true);
                    } else {
                        statusLineManager.setErrorMessage(message);
                        statusLineManager.update(true);
                    }
                }
            });
        }
    }
}

