/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class StaticConstantsRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.VariableID, (node, tokenQuery, problems) -> this.checkVariableNode((IVariableNode)node, tokenQuery, problems));
        return result;
    }

    private void checkVariableNode(IVariableNode variableNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        if (!variableNode.isConst() || variableNode.hasModifier(ASModifier.STATIC)) {
            return;
        }
        IScopedNode containingScope = variableNode.getContainingScope();
        if (containingScope == null) {
            return;
        }
        IASNode possibleClass = containingScope.getParent();
        if (!(possibleClass instanceof IClassNode)) {
            return;
        }
        problems.add(new StaticConstantsLinterProblem(variableNode));
    }

    public static class StaticConstantsLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Constant must be static";

        public StaticConstantsLinterProblem(IVariableNode node) {
            super((ISourceLocation)node);
        }
    }
}

