/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckPathsBetweenNodes;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.MaybeReachingVariableUse;
import com.google.javascript.jscomp.MustBeReachingVariableDef;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

class FlowSensitiveInlineVariables
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private final AbstractCompiler compiler;
    private ControlFlowGraph<Node> cfg;
    private Set<Candidate> candidates;
    private MustBeReachingVariableDef reachingDef;
    private MaybeReachingVariableUse reachingUses;
    private static final Predicate<Node> SIDE_EFFECT_PREDICATE = new SideEffectPredicate();

    private static boolean isTopLevelAssignTarget(Node n) {
        Node ancestor = n.getParent();
        while (ancestor.isAssign()) {
            ancestor = ancestor.getParent();
        }
        return ancestor.isExprResult();
    }

    public FlowSensitiveInlineVariables(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return !n.isScript() || !t.getInput().isExtern();
    }

    @Override
    public void enterScope(NodeTraversal t) {
        if (t.inGlobalScope()) {
            return;
        }
        if (!t.getScope().isFunctionBlockScope()) {
            return;
        }
        Node functionScopeRoot = t.getScopeRoot().getParent();
        if (!this.isCandidateFunction(functionScopeRoot)) {
            return;
        }
        if (100 < t.getScope().getVarCount()) {
            return;
        }
        Es6SyntacticScopeCreator scopeCreator = (Es6SyntacticScopeCreator)t.getScopeCreator();
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(this.compiler, false, true);
        cfa.process(null, functionScopeRoot);
        this.cfg = cfa.getCfg();
        this.reachingDef = new MustBeReachingVariableDef(this.cfg, t.getScope(), this.compiler, scopeCreator);
        this.reachingDef.analyze();
        this.candidates = new LinkedHashSet<Candidate>();
        NodeTraversal.traverse(this.compiler, t.getScopeRoot(), new GatherCandidates());
        this.reachingUses = new MaybeReachingVariableUse(this.cfg, t.getScope(), this.compiler, scopeCreator);
        this.reachingUses.analyze();
        while (!this.candidates.isEmpty()) {
            Candidate c = this.candidates.iterator().next();
            if (c.canInline(t.getScope())) {
                c.inlineVariable();
                this.candidates.remove(c);
                if (((Candidate)c).defMetadata.depends.isEmpty()) continue;
                Iterator<Candidate> it = this.candidates.iterator();
                while (it.hasNext()) {
                    Candidate other = it.next();
                    if (!((Candidate)other).defMetadata.depends.contains(t.getScope().getVar(c.varName)) || ((Candidate)other).defMetadata.depends.containsAll(((Candidate)c).defMetadata.depends)) continue;
                    it.remove();
                }
                continue;
            }
            this.candidates.remove(c);
        }
    }

    private boolean isCandidateFunction(Node fn) {
        Node fnBody = fn.getLastChild();
        return FlowSensitiveInlineVariables.containsCandidateExpressions(fnBody);
    }

    private static boolean containsCandidateExpressions(Node n) {
        if (n.isFunction()) {
            return false;
        }
        if ((NodeUtil.isNameDeclaration(n) || FlowSensitiveInlineVariables.isAssignmentToName(n)) && n.getFirstChild().isName()) {
            return true;
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (!FlowSensitiveInlineVariables.containsCandidateExpressions(c)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssignmentToName(Node n) {
        if (NodeUtil.isAssignmentOp(n) || n.isDec() || n.isInc()) {
            return n.getFirstChild().isName();
        }
        return false;
    }

    @Override
    public void exitScope(NodeTraversal t) {
    }

    @Override
    public void process(Node externs, Node root) {
        new NodeTraversal(this.compiler, this, new Es6SyntacticScopeCreator(this.compiler)).traverseRoots(externs, root);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
    }

    private static boolean checkPostExpressions(Node n, Node expressionRoot, Predicate<Node> predicate) {
        for (Node p = n; p != expressionRoot; p = p.getParent()) {
            for (Node cur = p.getNext(); cur != null; cur = cur.getNext()) {
                if (!predicate.apply(cur)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkPreExpressions(Node n, Node expressionRoot, Predicate<Node> predicate) {
        for (Node p = n; p != expressionRoot; p = p.getParent()) {
            Node oldestSibling = p.getParent().getFirstChild();
            if (oldestSibling.isDestructuringPattern()) {
                if (!p.isDestructuringPattern() || p.getNext() == null || !predicate.apply(p.getNext())) continue;
                return true;
            }
            for (Node cur = oldestSibling; cur != p; cur = cur.getNext()) {
                if (!predicate.apply(cur)) continue;
                return true;
            }
        }
        return false;
    }

    private class Candidate {
        private final String varName;
        private Node def;
        private final MustBeReachingVariableDef.Definition defMetadata;
        private final Node use;
        private final Node useCfgNode;
        private int numUsesWithinCfgNode;

        Candidate(String varName, MustBeReachingVariableDef.Definition defMetadata, Node use, Node useCfgNode) {
            Preconditions.checkArgument(use.isName());
            this.varName = varName;
            this.defMetadata = defMetadata;
            this.use = use;
            this.useCfgNode = useCfgNode;
        }

        private Node getDefCfgNode() {
            return this.defMetadata.node;
        }

        private boolean canInline(Scope scope) {
            CheckPathsBetweenNodes pathCheck;
            if (this.getDefCfgNode().isFunction()) {
                return false;
            }
            this.getDefinition(this.getDefCfgNode());
            this.getNumUseInUseCfgNode(this.useCfgNode);
            if (this.def == null) {
                return false;
            }
            if (this.def.isAssign() && !NodeUtil.isExprAssign(this.def.getParent())) {
                return false;
            }
            HashSet<String> namesToCheck = new HashSet<String>();
            if (this.defMetadata.depends != null) {
                for (Var var : this.defMetadata.depends) {
                    namesToCheck.add(var.getName());
                }
            }
            SideEffectPredicate sideEffectPredicateWithNames = new SideEffectPredicate(namesToCheck);
            if (FlowSensitiveInlineVariables.checkPostExpressions(this.def, this.getDefCfgNode(), sideEffectPredicateWithNames)) {
                return false;
            }
            if (FlowSensitiveInlineVariables.checkPreExpressions(this.use, this.useCfgNode, sideEffectPredicateWithNames)) {
                return false;
            }
            if (NodeUtil.mayHaveSideEffects(this.def.getLastChild(), FlowSensitiveInlineVariables.this.compiler)) {
                return false;
            }
            if (this.numUsesWithinCfgNode != 1) {
                return false;
            }
            if (NodeUtil.isWithinLoop(this.use)) {
                return false;
            }
            Collection<Node> uses = FlowSensitiveInlineVariables.this.reachingUses.getUses(this.varName, this.getDefCfgNode());
            if (uses.size() != 1) {
                return false;
            }
            if (!this.isRhsSafeToInline(scope)) {
                return false;
            }
            return !NodeUtil.isStatementBlock(this.getDefCfgNode().getParent()) || this.getDefCfgNode().getNext() == this.useCfgNode || !(pathCheck = new CheckPathsBetweenNodes(FlowSensitiveInlineVariables.this.cfg, FlowSensitiveInlineVariables.this.cfg.getDirectedGraphNode(this.getDefCfgNode()), FlowSensitiveInlineVariables.this.cfg.getDirectedGraphNode(this.useCfgNode), SIDE_EFFECT_PREDICATE, Predicates.alwaysTrue(), false)).somePathsSatisfyPredicate();
        }

        private void inlineVariable() {
            Node defParent = this.def.getParent();
            Node useParent = this.use.getParent();
            if (this.def.isAssign()) {
                Node rhs = this.def.getLastChild();
                rhs.detach();
                Preconditions.checkState(defParent.isExprResult());
                while (defParent.getParent().isLabel()) {
                    defParent = defParent.getParent();
                }
                FlowSensitiveInlineVariables.this.compiler.reportChangeToEnclosingScope(defParent);
                defParent.detach();
                useParent.replaceChild(this.use, rhs);
            } else if (NodeUtil.isNameDeclaration(defParent)) {
                Node rhs = this.def.getLastChild();
                if (defParent.isConst()) {
                    this.def.replaceChild(rhs, Node.newString(Token.NAME, "undefined"));
                    useParent.replaceChild(this.use, rhs);
                } else {
                    this.def.removeChild(rhs);
                    useParent.replaceChild(this.use, rhs);
                }
            } else {
                throw new IllegalStateException("No other definitions can be inlined.");
            }
            FlowSensitiveInlineVariables.this.compiler.reportChangeToEnclosingScope(useParent);
        }

        private void getDefinition(Node n) {
            ControlFlowGraph.AbstractCfgNodeTraversalCallback gatherCb = new ControlFlowGraph.AbstractCfgNodeTraversalCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    switch (n.getToken()) {
                        case NAME: {
                            if (n.getString().equals(Candidate.this.varName) && n.hasChildren()) {
                                Candidate.this.def = n;
                            }
                            return;
                        }
                        case ASSIGN: {
                            Node lhs = n.getFirstChild();
                            if (lhs.isName() && lhs.getString().equals(Candidate.this.varName)) {
                                Candidate.this.def = n;
                            }
                            return;
                        }
                    }
                }
            };
            NodeTraversal.traverse(FlowSensitiveInlineVariables.this.compiler, n, gatherCb);
        }

        private void getNumUseInUseCfgNode(final Node cfgNode) {
            this.numUsesWithinCfgNode = 0;
            ControlFlowGraph.AbstractCfgNodeTraversalCallback gatherCb = new ControlFlowGraph.AbstractCfgNodeTraversalCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    if (n.isName() && n.getString().equals(Candidate.this.varName)) {
                        if (parent.isAssign() && parent.getFirstChild() == n && this.isAssignChain(parent, cfgNode)) {
                            return;
                        }
                        Candidate.this.numUsesWithinCfgNode++;
                    }
                }

                private boolean isAssignChain(Node child, Node ancestor) {
                    for (Node n = child; n != ancestor; n = n.getParent()) {
                        if (n.isAssign()) continue;
                        return false;
                    }
                    return true;
                }
            };
            NodeTraversal.traverse(FlowSensitiveInlineVariables.this.compiler, cfgNode, gatherCb);
        }

        private boolean isRhsSafeToInline(final Scope usageScope) {
            if (NodeUtil.has(this.def.getLastChild(), new Predicate<Node>(){

                @Override
                public boolean apply(Node input) {
                    switch (input.getToken()) {
                        case GETELEM: 
                        case GETPROP: 
                        case ARRAYLIT: 
                        case OBJECTLIT: 
                        case REGEXP: 
                        case NEW: {
                            return true;
                        }
                    }
                    return false;
                }
            }, new Predicate<Node>(){

                @Override
                public boolean apply(Node input) {
                    return !input.isFunction();
                }
            })) {
                return false;
            }
            return !NodeUtil.has(this.def.getLastChild(), new Predicate<Node>(){

                @Override
                public boolean apply(Node input) {
                    String name;
                    return input.isName() && !(name = input.getString()).isEmpty() && !usageScope.hasSlot(name);
                }
            }, Predicates.alwaysTrue());
        }
    }

    private class GatherCandidates
    extends NodeTraversal.AbstractShallowCallback {
        final GatherCandidatesCfgNodeCallback gatherCb;

        private GatherCandidates() {
            this.gatherCb = new GatherCandidatesCfgNodeCallback();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            DiGraph.DiGraphNode graphNode = FlowSensitiveInlineVariables.this.cfg.getDirectedGraphNode(n);
            if (graphNode == null) {
                return;
            }
            Node cfgNode = n;
            this.gatherCb.setCfgNode(cfgNode);
            NodeTraversal.traverse(FlowSensitiveInlineVariables.this.compiler, cfgNode, this.gatherCb);
        }
    }

    private class GatherCandidatesCfgNodeCallback
    extends ControlFlowGraph.AbstractCfgNodeTraversalCallback {
        Node cfgNode = null;

        private GatherCandidatesCfgNodeCallback() {
        }

        public void setCfgNode(Node cfgNode) {
            this.cfgNode = cfgNode;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName()) {
                if (parent == null) {
                    return;
                }
                if (NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == n || NodeUtil.isNameDeclaration(parent) || parent.isInc() || parent.isDec() || parent.isParamList() || parent.isCatch() || NodeUtil.isLhsByDestructuring(n)) {
                    return;
                }
                String name = n.getString();
                if (FlowSensitiveInlineVariables.this.compiler.getCodingConvention().isExported(name)) {
                    return;
                }
                MustBeReachingVariableDef.Definition def = FlowSensitiveInlineVariables.this.reachingDef.getDef(name, this.cfgNode);
                if (def != null && !FlowSensitiveInlineVariables.this.reachingDef.dependsOnOuterScopeVars(def)) {
                    FlowSensitiveInlineVariables.this.candidates.add(new Candidate(name, def, n, this.cfgNode));
                }
            }
        }
    }

    private static class SideEffectPredicate
    implements Predicate<Node> {
        private final Set<String> namesToCheck;

        public SideEffectPredicate() {
            this.namesToCheck = null;
        }

        public SideEffectPredicate(Set<String> names) {
            this.namesToCheck = names;
        }

        @Override
        public boolean apply(Node n) {
            if (n == null) {
                return false;
            }
            if (this.namesToCheck != null && n.isName() && this.namesToCheck.contains(n.getString()) && NodeUtil.isLValue(n)) {
                return !FlowSensitiveInlineVariables.isTopLevelAssignTarget(n);
            }
            if (n.isCall() && NodeUtil.functionCallHasSideEffects(n)) {
                return true;
            }
            if (n.isNew() && NodeUtil.constructorCallHasSideEffects(n)) {
                return true;
            }
            if (n.isDelProp()) {
                return true;
            }
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                if (ControlFlowGraph.isEnteringNewCfgNode(c) || !this.apply(c)) continue;
                return true;
            }
            return false;
        }
    }
}

