/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.jgoodies.plaf.plastic;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;
import org.tp23.jgoodies.plaf.plastic.BorderStyle;
import org.tp23.jgoodies.plaf.plastic.HeaderStyle;
import org.tp23.jgoodies.plaf.plastic.PlasticUtils;
import org.tp23.jgoodies.plaf.plastic.PlasticXPLookAndFeel;

public final class PlasticMenuBarUI
extends BasicMenuBarUI {
    private PropertyChangeListener listener;

    public static ComponentUI createUI(JComponent b) {
        return new PlasticMenuBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.installSpecialBorder();
    }

    protected void installListeners() {
        super.installListeners();
        this.listener = this.createBorderStyleListener();
        this.menuBar.addPropertyChangeListener(this.listener);
    }

    protected void uninstallListeners() {
        this.menuBar.removePropertyChangeListener(this.listener);
        super.uninstallListeners();
    }

    private PropertyChangeListener createBorderStyleListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (prop.equals("jgoodies.headerStyle") || prop.equals("Plastic.borderStyle")) {
                    PlasticMenuBarUI.this.installSpecialBorder();
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public void installSpecialBorder() {
        void var1_2;
        String suffix;
        BorderStyle borderStyle = BorderStyle.from(this.menuBar, "Plastic.borderStyle");
        if (borderStyle == BorderStyle.EMPTY) {
            suffix = "emptyBorder";
        } else if (borderStyle == BorderStyle.ETCHED) {
            suffix = "etchedBorder";
        } else if (borderStyle == BorderStyle.SEPARATOR) {
            suffix = "separatorBorder";
        } else {
            HeaderStyle headerStyle = HeaderStyle.from(this.menuBar);
            if (headerStyle == HeaderStyle.BOTH) {
                suffix = "headerBorder";
            } else if (headerStyle == HeaderStyle.SINGLE && this.is3D()) {
                suffix = "etchedBorder";
            } else {
                return;
            }
        }
        LookAndFeel.installBorder(this.menuBar, "MenuBar." + (String)var1_2);
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        if (this.is3D()) {
            PlasticUtils.addLight3DEffekt(g, new Rectangle(0, 0, c.getWidth(), c.getHeight()), true);
        }
        Graphics2D g2 = (Graphics2D)g;
        if (PlasticXPLookAndFeel.isAntiAliased()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.paint(g, c);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private boolean is3D() {
        if (PlasticUtils.force3D(this.menuBar)) {
            return true;
        }
        if (PlasticUtils.forceFlat(this.menuBar)) {
            return false;
        }
        return PlasticUtils.is3D("MenuBar.") && HeaderStyle.from(this.menuBar) != null && BorderStyle.from(this.menuBar, "Plastic.borderStyle") != BorderStyle.EMPTY;
    }
}

