/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.logic;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.tp23.antinstaller.input.ResultContainer;
import org.tp23.antinstaller.runtime.ConfigurationException;
import org.tp23.antinstaller.runtime.logic.CompoundExpression;
import org.tp23.antinstaller.runtime.logic.EndsWithTest;
import org.tp23.antinstaller.runtime.logic.EqualsTest;
import org.tp23.antinstaller.runtime.logic.Expression;
import org.tp23.antinstaller.runtime.logic.GreaterThanOrEqualsTest;
import org.tp23.antinstaller.runtime.logic.LessThanOrEqualsTest;
import org.tp23.antinstaller.runtime.logic.LogicalAndTest;
import org.tp23.antinstaller.runtime.logic.LogicalOrTest;
import org.tp23.antinstaller.runtime.logic.LogicalTest;
import org.tp23.antinstaller.runtime.logic.NotEqualsTest;
import org.tp23.antinstaller.runtime.logic.SimpleExpression;
import org.tp23.antinstaller.runtime.logic.SingleExpressionTest;
import org.tp23.antinstaller.runtime.logic.StartsWithTest;
import org.tp23.antinstaller.runtime.logic.StringLengthComparator;
import org.tp23.antinstaller.runtime.logic.ValuesTest;

public class ExpressionBuilder {
    private static final int GROUPING_START_OPERATOR = 40;
    private static final int GROUPING_END_OPERATOR = 41;
    private static final ValuesTest[] testValueConditions;
    private static final LogicalTest[] testLogicalConditions;
    private static final SingleExpressionTest SINGLE_EXPRESSION_TEST;
    private static Map tokenMap;
    private static String[] valueTokens;
    private static String[] logicalTokens;

    public static Expression parseLogicalExpressions(ResultContainer container, String exprStr) throws ConfigurationException {
        int endIndex;
        int startIndex = ExpressionBuilder.skipWhiteSpace(exprStr, 0);
        int index = exprStr.indexOf(40, startIndex);
        if (index == -1) {
            return ExpressionBuilder.getSimpleExpression(container, exprStr.substring(startIndex));
        }
        if (index != 0) {
            throw new ConfigurationException("Illegal ifProperty value: If present, grouping operator 40 must be at start of property string");
        }
        if ((endIndex = exprStr.indexOf(41, ++startIndex)) == -1) {
            throw new ConfigurationException("Missing closing grouping bracket 41 in expression " + exprStr);
        }
        int tstIndex = exprStr.indexOf(40, startIndex);
        if (tstIndex != -1 && tstIndex < endIndex) {
            throw new ConfigurationException("Nesting of logical operations is not supported: " + exprStr);
        }
        try {
            Expression expr1 = ExpressionBuilder.parseLogicalExpressions(container, exprStr.substring(startIndex, endIndex));
            LogicalTest test = null;
            startIndex = endIndex + 1;
            String logicalToken = ExpressionBuilder.getLogicalToken(exprStr, startIndex);
            for (int i = 0; i < logicalTokens.length; ++i) {
                if (logicalTokens[i].compareTo(logicalToken) != 0) continue;
                test = (LogicalTest)tokenMap.get(logicalTokens[i]);
                index = exprStr.indexOf(logicalTokens[i], startIndex);
                startIndex = index + logicalTokens[i].length();
                break;
            }
            if (test == null) {
                return new CompoundExpression(expr1, SINGLE_EXPRESSION_TEST, null);
            }
            startIndex = ExpressionBuilder.skipWhiteSpace(exprStr, startIndex);
            String expr2Str = exprStr.substring(startIndex, exprStr.length());
            return new CompoundExpression(expr1, test, ExpressionBuilder.parseLogicalExpressions(container, expr2Str));
        }
        catch (Exception e) {
            throw new ConfigurationException("Invalid ifProperty expression");
        }
    }

    private static Expression getSimpleExpression(ResultContainer resultContainer, String exprStr) throws ConfigurationException {
        try {
            int i;
            int index = -1;
            for (i = 0; i < valueTokens.length && (index = exprStr.indexOf(valueTokens[i])) == -1; ++i) {
            }
            return new SimpleExpression(resultContainer, exprStr.substring(0, index), (ValuesTest)tokenMap.get(valueTokens[i]), exprStr.substring(index + valueTokens[i].length()));
        }
        catch (Exception e) {
            throw new ConfigurationException("Invalid ifProperty expression");
        }
    }

    private static int skipWhiteSpace(String str, int startIndex) {
        int index;
        int strLen = str.length();
        for (index = startIndex; index < strLen && (str.charAt(index) == ' ' || str.charAt(index) == '\t'); ++index) {
        }
        return index;
    }

    private static String getLogicalToken(String str, int startIndex) {
        int tokenStart;
        char chr;
        int endIndex;
        int strLen = str.length();
        for (endIndex = tokenStart = ExpressionBuilder.skipWhiteSpace(str, startIndex); endIndex < strLen && (chr = str.charAt(endIndex)) != ' ' && chr != '\t' && chr != '('; ++endIndex) {
        }
        return str.substring(tokenStart, endIndex);
    }

    static {
        int j;
        String[] tmpTokens;
        int i;
        testValueConditions = new ValuesTest[]{new EndsWithTest(), new EqualsTest(), new GreaterThanOrEqualsTest(), new LessThanOrEqualsTest(), new NotEqualsTest(), new StartsWithTest()};
        testLogicalConditions = new LogicalTest[]{new LogicalAndTest(), new LogicalOrTest()};
        SINGLE_EXPRESSION_TEST = new SingleExpressionTest();
        tokenMap = new HashMap();
        for (int i2 = 0; i2 < testValueConditions.length; ++i2) {
            String[] tmpTokens2 = testValueConditions[i2].getTestTokens();
            for (int j2 = 0; j2 < tmpTokens2.length; ++j2) {
                tokenMap.put(tmpTokens2[j2], testValueConditions[i2]);
            }
        }
        valueTokens = new String[tokenMap.size()];
        int index = 0;
        for (int i3 = 0; i3 < testValueConditions.length; ++i3) {
            String[] tmpTokens3 = testValueConditions[i3].getTestTokens();
            for (int j3 = 0; j3 < tmpTokens3.length; ++j3) {
                ExpressionBuilder.valueTokens[index++] = tmpTokens3[j3];
            }
        }
        StringLengthComparator lengthComparator = new StringLengthComparator();
        Arrays.sort(valueTokens, lengthComparator);
        index = 0;
        int mapInitialSize = tokenMap.size();
        for (i = 0; i < testLogicalConditions.length; ++i) {
            tmpTokens = testLogicalConditions[i].getTestTokens();
            for (j = 0; j < tmpTokens.length; ++j) {
                tokenMap.put(tmpTokens[j], testLogicalConditions[i]);
            }
        }
        logicalTokens = new String[tokenMap.size() - mapInitialSize];
        for (i = 0; i < testLogicalConditions.length; ++i) {
            tmpTokens = testLogicalConditions[i].getTestTokens();
            for (j = 0; j < tmpTokens.length; ++j) {
                ExpressionBuilder.logicalTokens[index++] = tmpTokens[j];
            }
        }
        Arrays.sort(logicalTokens, lengthComparator);
    }
}

