/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.page.TextPage;
import org.tp23.antinstaller.renderer.text.AbstractTextPageRenderer;
import org.tp23.antinstaller.renderer.text.Pager;

public class TextPageRenderer
extends AbstractTextPageRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");
    private static final String nextChar = res.getString("nextChar");

    public boolean renderPage(Page page) throws InstallException {
        if (page instanceof TextPage) {
            TextPage lPage = (TextPage)page;
            return this.renderTextPage(lPage);
        }
        throw new InstallException("Wrong Renderer in TextPageRenderer.renderPage");
    }

    private boolean renderTextPage(TextPage page) throws InstallException {
        try {
            BufferedReader commandReader = this.reader;
            String resource = page.getTextResource();
            InputStream textin = this.getClass().getResourceAsStream(resource);
            BufferedReader reader = new BufferedReader(new InputStreamReader(textin));
            this.printHeader(page);
            String lineread = null;
            StringBuffer sb = new StringBuffer();
            while ((lineread = reader.readLine()) != null) {
                sb.append(lineread);
                sb.append('\n');
            }
            reader.close();
            String parsedText = this.getContext().getInstaller().getResultContainer().getDefaultValue(sb.toString());
            String command = null;
            Pager pager = new Pager(parsedText);
            while (pager.next(this.out)) {
                this.out.println();
                this.out.println(this.getNextInstructions());
                command = commandReader.readLine();
                if (command.toUpperCase().startsWith(nextChar)) continue;
            }
            pager.rest(this.out);
            for (int i = 0; i < 80; ++i) {
                this.out.print('~');
            }
            this.out.println();
            this.out.println(res.getString("clickViewText"));
            commandReader.readLine();
            return true;
        }
        catch (IOException ex) {
            throw new InstallException("Not able to read text file", ex);
        }
    }

    private String getNextInstructions() {
        return res.getString("license_next");
    }
}

