/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.LargeSelectInput;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.renderer.text.Pager;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class LargeSelectInputRenderer
implements TextOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");
    private static final String nextChar = res.getString("nextChar");
    protected InstallerContext ctx;

    public void setContext(InstallerContext ctx) {
        this.ctx = ctx;
    }

    public void renderOutput(OutputField field, BufferedReader reader, PrintStream out) throws IOException {
        LargeSelectInput iField = (LargeSelectInput)field;
        this.printText(iField, out, reader);
        String input = reader.readLine();
        out.println();
        if (input == null || input.equals("")) {
            input = iField.getDefaultValue();
        } else {
            try {
                int idx = Integer.parseInt(input.trim());
                input = iField.getOptions()[idx - 1].value;
            }
            catch (Exception numFormatOrIndexOutOfBounds) {
                return;
            }
        }
        iField.setInputResult(input);
    }

    public boolean isAbort() {
        return false;
    }

    private void printText(LargeSelectInput iField, PrintStream out, BufferedReader reader) throws IOException {
        out.println(iField.getDisplayText());
        LargeSelectInput.Option[] options = iField.getOptions();
        out.print("  ");
        out.println(res.getString("availableOptions"));
        StringBuffer optionsData = new StringBuffer();
        for (int i = 0; i < options.length; ++i) {
            optionsData.append("  ");
            optionsData.append(i + 1);
            optionsData.append(") ");
            optionsData.append(options[i].getText());
            if (iField.getDefaultValue().equals(options[i].value)) {
                optionsData.append(" [");
                optionsData.append(res.getString("_default_"));
                optionsData.append("]");
            }
            optionsData.append("\n");
        }
        optionsData.append("  ");
        optionsData.append(res.getString("enterNumber")).append("\n");
        Pager pager = new Pager(optionsData.toString());
        String command = null;
        while (pager.next(out)) {
            out.println();
            out.println(this.getNextInstructions());
            command = reader.readLine();
            if (command.toUpperCase().startsWith(nextChar)) continue;
        }
        pager.rest(out);
    }

    public void renderError(OutputField field, BufferedReader reader, PrintStream out) throws IOException {
        this.ctx.getMessageRenderer().printMessage("Not a valid selection");
        this.renderOutput(field, reader, out);
    }

    private String getNextInstructions() {
        return res.getString("large_select_next");
    }
}

