/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.renderer.MessageRenderer;

public class SwingMessageRenderer
implements MessageRenderer {
    private InstallerContext ctx = null;
    private JFrame owner = null;

    public SwingMessageRenderer() {
    }

    public SwingMessageRenderer(InstallerContext ctx) {
        this.ctx = ctx;
    }

    public void setInstallerContext(InstallerContext ctx) {
        this.ctx = ctx;
    }

    public void printMessage(String message) {
        MessageRunnable messageRunnable = new MessageRunnable();
        messageRunnable.message = message;
        if (SwingUtilities.isEventDispatchThread()) {
            messageRunnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(messageRunnable);
            }
            catch (Exception e) {
                this.ctx.log(e);
            }
        }
    }

    public boolean prompt(String message) {
        OptionRunnable optionRunnable = new OptionRunnable();
        optionRunnable.message = message;
        if (SwingUtilities.isEventDispatchThread()) {
            optionRunnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(optionRunnable);
            }
            catch (Exception e) {
                this.ctx.log(e);
            }
        }
        return optionRunnable.ok;
    }

    public void setOwner(JFrame owner) {
        this.owner = owner;
    }

    private class OptionRunnable
    implements Runnable {
        String message;
        boolean ok;

        private OptionRunnable() {
        }

        public void run() {
            int ret = JOptionPane.showConfirmDialog(SwingMessageRenderer.this.owner, this.message, "Question", 0);
            this.ok = ret == 0;
        }
    }

    private class MessageRunnable
    implements Runnable {
        String message;

        private MessageRunnable() {
        }

        public void run() {
            JOptionPane.showMessageDialog(SwingMessageRenderer.this.owner, this.message, "Message", 1);
        }
    }
}

