/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.antmod.taskdefs;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.tp23.antinstaller.InstallerContext;

public final class PropertyTask
extends Task {
    private String name;
    private String value;
    private String resource;

    public void execute() throws BuildException {
        if (this.resource != null) {
            this.executeResource();
        } else {
            if (this.name == null || this.value == null) {
                throw new BuildException("either resource or (name and value) can not be null for antinstaller-property task");
            }
            this.executePropVal();
        }
    }

    private void executePropVal() {
        InstallerContext ctx = (InstallerContext)this.getProject().getReference("antinstaller.internal.context");
        ctx.log("setting property: name=" + this.name + ", value=" + this.value);
        ctx.getInstaller().getResultContainer().setProperty(this.name, this.value);
    }

    private void executeResource() throws BuildException {
        InstallerContext ctx = (InstallerContext)this.getProject().getReference("antinstaller.internal.context");
        InputStream is = this.getClass().getResourceAsStream(this.resource);
        if (is == null) {
            ctx.log("Can not find resource: " + this.resource);
            throw new BuildException("Can not find resource: " + this.resource);
        }
        try {
            Properties props = new Properties();
            props.load(is);
            is.close();
            if (ctx.getInstaller().isVerbose()) {
                ctx.log("loaded properties: " + props.size());
            }
            ctx.getInstaller().getResultContainer().getAllProperties().putAll(props);
        }
        catch (IOException e) {
            ctx.log("Can not load resource: " + this.resource);
            throw new BuildException("Can not load resource: " + this.resource);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }
}

