/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.PropertiesFileRenderer;
import org.tp23.antinstaller.input.ConditionalField;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.SecretPropertyField;
import org.tp23.antinstaller.page.Page;

public class ExplicitPropertiesFileRenderer
implements PropertiesFileRenderer {
    private static String newLine = System.getProperty("line.separator");
    private static final char[] hexidecimals = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public void renderProperties(InstallerContext ctx, File baseDir) {
        block4: {
            Installer installer = ctx.getInstaller();
            Page[] completedPages = installer.getPages();
            StringBuffer propertiesData = new StringBuffer();
            propertiesData.append("### Ant Installer - properties auto generated on ");
            propertiesData.append(this.convert(new Date().toString(), true));
            propertiesData.append(newLine);
            propertiesData.append(newLine);
            propertiesData.append("basedir");
            propertiesData.append(" = ");
            propertiesData.append(this.convert(baseDir.getAbsolutePath(), true));
            propertiesData.append(newLine);
            propertiesData.append("ant.install.config.version");
            propertiesData.append(" = ");
            propertiesData.append(this.convert(ctx.getInstaller().getVersion(), true));
            propertiesData.append(newLine);
            propertiesData.append(newLine);
            String property = null;
            String value = null;
            for (int i = 0; i < completedPages.length; ++i) {
                OutputField[] fields = completedPages[i].getOutputField();
                propertiesData.append(newLine);
                propertiesData.append("## Properties from Page:" + completedPages[i].getName());
                propertiesData.append(newLine);
                this.retrievePropertiesData(fields, propertiesData);
                List targets = completedPages[i].getTargets(ctx);
                if (targets.size() <= 0) continue;
                Iterator iterator = targets.iterator();
                StringBuffer targetProperty = new StringBuffer();
                while (iterator.hasNext()) {
                    String target = (String)iterator.next();
                    targetProperty.append(target).append(",");
                }
                propertiesData.append("# Targets selected for page");
                propertiesData.append(newLine);
                property = this.convert(completedPages[i].getName() + "-targets", true);
                value = this.convert(targetProperty.toString(), true);
                propertiesData.append(property + " = " + value);
                propertiesData.append(newLine);
            }
            try {
                File antInstallProperties = new File(baseDir.getAbsolutePath(), "ant.install.properties");
                FileWriter fos = new FileWriter(antInstallProperties);
                BufferedWriter writer = new BufferedWriter(fos);
                writer.write(propertiesData.toString());
                writer.flush();
                fos.close();
            }
            catch (Throwable ex) {
                if (!ctx.getInstaller().isVerbose()) break block4;
                ctx.log(ex);
            }
        }
    }

    private void retrievePropertiesData(OutputField[] fields, StringBuffer propertiesData) {
        String property = null;
        String value = null;
        for (int f = 0; f < fields.length; ++f) {
            InputField field;
            if (fields[f] instanceof SecretPropertyField) {
                field = (InputField)fields[f];
                propertiesData.append("# Property hidden " + this.printClass(fields[f].getClass()));
                propertiesData.append(newLine);
                property = this.convert(field.getProperty(), true);
                propertiesData.append("#" + property + "=XXXXXXXX");
                propertiesData.append(newLine);
                continue;
            }
            if (fields[f] instanceof ConditionalField) {
                ConditionalField confField = (ConditionalField)fields[f];
                this.retrievePropertiesData(confField.getFields(), propertiesData);
                continue;
            }
            if (!(fields[f] instanceof InputField)) continue;
            field = (InputField)fields[f];
            String result = field.getInputResult();
            propertiesData.append("# " + this.printClass(fields[f].getClass()));
            propertiesData.append(newLine);
            property = this.convert(field.getProperty(), true);
            value = this.convert(result, false);
            propertiesData.append(property + " = " + value);
            propertiesData.append(newLine);
        }
    }

    private String printClass(Class clazz) {
        String name = clazz.getName();
        int lastDot = name.lastIndexOf(46);
        return name.substring(lastDot, name.length());
    }

    private String convert(String input, boolean doSpaces) {
        if (input == null) {
            return "";
        }
        int num = input.length();
        StringBuffer sb = new StringBuffer(num);
        block12: for (int i = 0; i < num; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case ' ': {
                    if (i == 0 || doSpaces) {
                        sb.append('\\');
                    }
                    sb.append(' ');
                    continue block12;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block12;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block12;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block12;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block12;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block12;
                }
                case '=': {
                    sb.append("\\=");
                    continue block12;
                }
                case ':': {
                    sb.append("\\:");
                    continue block12;
                }
                case '#': {
                    sb.append("\\#");
                    continue block12;
                }
                case '!': {
                    sb.append("\\!");
                    continue block12;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        sb.append("\\u").append(this.hex(c >> 12 & 0xF)).append(this.hex(c >> 8 & 0xF)).append(this.hex(c >> 4 & 0xF)).append(this.hex(c & 0xF));
                        continue block12;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private char hex(int val) {
        return hexidecimals[val & 0xF];
    }
}

