/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.anttasks;

import java.sql.Connection;
import java.sql.Driver;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class StartDerby
extends Task {
    public void execute() throws BuildException {
        try {
            if (StartDerby.getDriver(this.getProject()) != null) {
                System.out.println("Derby Driver has ALREADY BEEN ESTABLISHED!");
                return;
            }
            StartDerby.setDriver(this.getProject(), (Driver)Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance());
            System.out.println("Derby Driver has been started!");
        }
        catch (Exception e) {
            System.out.println("Derby could not start. This is most likely due to missing Derby JAR files. Please check your classpathand try again.");
            throw new BuildException(e);
        }
    }

    public static void setDriver(Project project, Driver d) {
        try {
            if (d != null) {
                project.addReference("DRIVER", d);
                System.out.println("Driver reference in Project set ");
            } else {
                Hashtable h = project.getReferences();
                h.remove("DRIVER");
                System.out.println("Driver reference in Project removed ");
            }
        }
        catch (Exception e) {
            System.out.println("Could't SET Driver reference in Project : " + e.getLocalizedMessage());
        }
    }

    public static Driver getDriver(Project project) {
        try {
            Object o = project.getReference("DRIVER");
            if (o != null) {
                return (Driver)o;
            }
            return null;
        }
        catch (Exception e) {
            System.out.println("Could't get Driver reference in Project : " + e.getLocalizedMessage());
            return null;
        }
    }

    public static void setConnection(Project project, Connection d) {
        try {
            if (d != null) {
                project.addReference("Connection", d);
                System.out.println("Connection reference in Project set ");
            } else {
                Hashtable h = project.getReferences();
                h.remove("Connection");
                System.out.println("Connection reference in Project removed ");
            }
        }
        catch (Exception e) {
            System.out.println("Could't SET Connection reference in Project : " + e.getLocalizedMessage());
        }
    }

    public static Connection getConnection(Project project) {
        try {
            Object o = project.getReference("Connection");
            if (o != null) {
                return (Connection)o;
            }
            return null;
        }
        catch (Exception e) {
            System.out.println("Could't get Connection reference in Project : " + e.getLocalizedMessage());
            return null;
        }
    }
}

