/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.bridges.frameworks;


/**
 * ForwardConstants
 * 
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: ForwardConstants.java 517068 2007-03-12 01:44:37Z ate $
 */
public interface ForwardConstants
{
    final String SUCCESS = "success";
    final String FAILURE = "failure";
    
    final String MODE_PREFIX = "mode:";
    final String STATE_PREFIX = "state:";
    
    final String MAXIMIZED = "maximized";
    final String MINIMIZED = "minimized";
    final String NORMAL = "normal";
    
    final String VIEW = "view";
    final String EDIT = "edit";
    final String HELP = "help";
    
    final String DELIMITER = ",";
}
