/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.groovy;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URLDecoder;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.codehaus.groovy.control.CompilationFailedException;

public class GroovyPortlet
extends GenericPortlet {
    public static final String SCRIPT_SOURCE_INIT_PARAM = "script-source";
    public static final String SCRIPT_SOURCE_URL_ENCODING_INIT_PARAM = "script-source-uri-encoding";
    public static final String AUTO_REFRESH_INIT_PARAM = "auto-refresh";
    protected PortletConfig portletConfig;
    protected String scriptSourceUri;
    protected String scriptSourceUriEncoding = "UTF-8";
    protected boolean autoRefresh;
    protected long parsedFileLastModified;
    protected GroovyCodeSource groovyCodeSource;
    protected Portlet scriptPortletInstance;
    protected GenericPortlet scriptGenericPortletInstance;
    protected Method portletDoEditMethod;
    protected GroovyClassLoader groovyClassLoader;

    public void init(PortletConfig config) throws PortletException {
        block12: {
            this.portletConfig = config;
            this.groovyClassLoader = new GroovyClassLoader();
            this.autoRefresh = "true".equals(config.getInitParameter(AUTO_REFRESH_INIT_PARAM));
            String param = config.getInitParameter(SCRIPT_SOURCE_URL_ENCODING_INIT_PARAM);
            if (param != null) {
                this.scriptSourceUriEncoding = param;
            }
            this.scriptSourceUri = config.getInitParameter(SCRIPT_SOURCE_INIT_PARAM);
            if (this.scriptSourceUri == null) {
                throw new PortletException("Configuration failed: script-source should be set properly!");
            }
            try {
                if (this.scriptSourceUri.startsWith("file:")) {
                    String decodedScriptSourceUri = this.scriptSourceUri;
                    try {
                        decodedScriptSourceUri = URLDecoder.decode(this.scriptSourceUri, this.scriptSourceUriEncoding);
                    }
                    catch (UnsupportedEncodingException encodingEx) {
                        throw new PortletException("Unsupported encoding: " + this.scriptSourceUriEncoding);
                    }
                    this.groovyCodeSource = new GroovyCodeSource(new File(decodedScriptSourceUri.substring(5)));
                    break block12;
                }
                if (this.scriptSourceUri.startsWith("classpath:")) {
                    String resourceURL = this.groovyClassLoader.getResource(this.scriptSourceUri.substring(10)).toString();
                    if (resourceURL.startsWith("file:")) {
                        String decodedScriptSourceUri = resourceURL;
                        try {
                            decodedScriptSourceUri = URLDecoder.decode(resourceURL, this.scriptSourceUriEncoding);
                        }
                        catch (UnsupportedEncodingException encodingEx) {
                            throw new PortletException("Unsupported encoding: " + this.scriptSourceUriEncoding);
                        }
                        this.groovyCodeSource = new GroovyCodeSource(new File(decodedScriptSourceUri.substring(5)));
                        break block12;
                    }
                    throw new PortletException("script-source with 'classpath:' prefix should indicate to a local resource");
                }
                this.groovyCodeSource = new GroovyCodeSource(new File(config.getPortletContext().getRealPath(this.scriptSourceUri)));
            }
            catch (FileNotFoundException e) {
                throw new PortletException("File not found: " + this.scriptSourceUri, (Throwable)e);
            }
        }
        this.groovyCodeSource.setCachable(!this.autoRefresh);
        this.refreshPortletInstance();
        if (this.scriptPortletInstance == null) {
            throw new PortletException("Groovy script portlet is not available!");
        }
    }

    public void destroy() {
        if (this.scriptPortletInstance != null) {
            this.scriptPortletInstance.destroy();
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        this.refreshPortletInstance();
        if (this.scriptPortletInstance == null) {
            throw new PortletException("Groovy script portlet is not available!");
        }
        this.scriptPortletInstance.processAction(request, response);
    }

    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.refreshPortletInstance();
        if (this.scriptPortletInstance == null) {
            throw new PortletException("Groovy script portlet is not available!");
        }
        this.scriptPortletInstance.render(request, response);
    }

    public PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (this.scriptGenericPortletInstance != null && this.portletDoEditMethod != null) {
            try {
                this.portletDoEditMethod.invoke((Object)this.scriptGenericPortletInstance, request, response);
            }
            catch (Exception e) {
                throw new PortletException("Failed to invoke doEdit method.", (Throwable)e);
            }
        } else {
            throw new PortletException("doEdit method not implemented or not public.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshPortletInstance() throws PortletException {
        if (this.scriptPortletInstance == null) {
            try {
                this.createScriptPortletInstance();
            }
            catch (Exception ex) {
                throw new PortletException("Could not compile script: " + this.scriptSourceUri, (Throwable)ex);
            }
        }
        if (this.autoRefresh && this.isScriptFileModified()) {
            Portlet portlet = this.scriptPortletInstance;
            synchronized (portlet) {
                try {
                    this.createScriptPortletInstance();
                }
                catch (Exception ex) {
                    throw new PortletException("Could not compile script: " + this.scriptSourceUri, (Throwable)ex);
                }
            }
        }
    }

    protected boolean isScriptFileModified() {
        return this.groovyCodeSource.getFile().lastModified() > this.parsedFileLastModified;
    }

    protected void createScriptPortletInstance() throws CompilationFailedException, InstantiationException, IOException, IllegalAccessException, PortletException {
        Class scriptPortletClass = this.groovyClassLoader.parseClass(this.groovyCodeSource);
        this.scriptPortletInstance = (Portlet)scriptPortletClass.newInstance();
        this.scriptGenericPortletInstance = null;
        this.portletDoEditMethod = null;
        if (this.scriptPortletInstance instanceof GenericPortlet) {
            this.scriptGenericPortletInstance = (GenericPortlet)this.scriptPortletInstance;
            try {
                Method doEditMethod = this.scriptGenericPortletInstance.getClass().getMethod("doEdit", RenderRequest.class, RenderResponse.class);
                if (Modifier.isPublic(doEditMethod.getModifiers())) {
                    this.portletDoEditMethod = doEditMethod;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.parsedFileLastModified = this.groovyCodeSource.getFile().lastModified();
        this.scriptPortletInstance.init(this.portletConfig);
    }
}

