/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.desktop;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.portals.bridges.velocity.GenericVelocityPortlet;
import org.apache.velocity.context.Context;

public class WeatherPortlet
extends GenericVelocityPortlet {
    public static final String WEATHER_CITY_INFO = "weather_city_info";
    public static final String WEATHER_STATE = "weather_state";
    public static final String WEATHER_CITY = "weather_city";
    public static final String WEATHER_STATION = "weather_station";
    public static final String WEATHER_STYLE = "weather_style";

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        Context context = super.getContext(request);
        String cityInfo = (String)request.getPortletSession().getAttribute(WEATHER_CITY_INFO);
        PortletPreferences prefs = request.getPreferences();
        String city = prefs.getValue(WEATHER_CITY, "Bakersfield");
        String state = prefs.getValue(WEATHER_STATE, "CA");
        String station = prefs.getValue(WEATHER_STATION, null);
        cityInfo = this.getCityInfo(city, state, station);
        context.put(WEATHER_CITY_INFO, (Object)cityInfo);
        String style = prefs.getValue(WEATHER_STYLE, "infobox");
        context.put(WEATHER_STYLE, (Object)style);
        response.setProperty("david", "taylor");
        super.doView(request, response);
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        this.doPreferencesEdit(request, response);
    }

    private String getUSInfo(String city, String state) {
        if ((city = city.trim().toLowerCase() + " ").indexOf(" ") > 0) {
            String newCity = "";
            StringTokenizer st = new StringTokenizer(city, " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                newCity = newCity + token.substring(0, 1).toUpperCase() + token.substring(1) + "_";
            }
            city = newCity.substring(0, newCity.length() - 1);
        }
        state = state.toUpperCase();
        return "US/" + state + "/" + city;
    }

    private String getCityInfo(String city, String state, String station) {
        String cityInfo = null;
        if (city != null && state != null && !city.equals("") && !state.equals("")) {
            cityInfo = this.getUSInfo(city, state);
        } else if (station != null && !station.equals("")) {
            cityInfo = "global/stations/" + station;
        }
        return cityInfo;
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String city = request.getParameter(WEATHER_CITY);
        String state = request.getParameter(WEATHER_STATE);
        String style = request.getParameter(WEATHER_STYLE);
        String station = request.getParameter(WEATHER_STATION);
        PortletPreferences prefs = request.getPreferences();
        prefs.setValue(WEATHER_CITY, city);
        prefs.setValue(WEATHER_STATE, state);
        prefs.setValue(WEATHER_STYLE, style);
        prefs.setValue(WEATHER_STATION, station);
        prefs.store();
        super.processAction(request, response);
    }
}

