/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.nar;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.toolkit.client.ControllerClient;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;

public class DeleteNar
extends AbstractNiFiCommand<VoidResult> {
    public DeleteNar() {
        super("delete-nar", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Deletes a NAR from the NAR Manager";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.NAR_ID.createOption());
        this.addOption(CommandOption.FORCE.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String narId = this.getRequiredArg(properties, CommandOption.NAR_ID);
        boolean forceDelete = properties.containsKey(CommandOption.FORCE.getLongName());
        ControllerClient controllerClient = client.getControllerClient();
        controllerClient.deleteNar(narId, forceDelete);
        return VoidResult.getInstance();
    }
}

