/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms.activemq;

import jakarta.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.autoconfigure.jms.JndiConnectionFactoryAutoConfiguration;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQConnectionDetails;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQConnectionFactoryConfiguration;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQProperties;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQXAConnectionFactoryConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@AutoConfiguration(before={JmsAutoConfiguration.class}, after={JndiConnectionFactoryAutoConfiguration.class})
@ConditionalOnClass(value={ConnectionFactory.class, ActiveMQConnectionFactory.class})
@ConditionalOnMissingBean(value={ConnectionFactory.class})
@EnableConfigurationProperties(value={ActiveMQProperties.class, JmsProperties.class})
@Import(value={ActiveMQXAConnectionFactoryConfiguration.class, ActiveMQConnectionFactoryConfiguration.class})
public class ActiveMQAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    ActiveMQConnectionDetails activemqConnectionDetails(ActiveMQProperties properties) {
        return new PropertiesActiveMQConnectionDetails(properties);
    }

    static class PropertiesActiveMQConnectionDetails
    implements ActiveMQConnectionDetails {
        private final ActiveMQProperties properties;

        PropertiesActiveMQConnectionDetails(ActiveMQProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getBrokerUrl() {
            return this.properties.determineBrokerUrl();
        }

        @Override
        public String getUser() {
            return this.properties.getUser();
        }

        @Override
        public String getPassword() {
            return this.properties.getPassword();
        }
    }
}

