/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.validator;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.trinidad.validator.ClientValidator;
import org.apache.myfaces.trinidadinternal.convert.GenericConverterFactory;
import org.apache.myfaces.trinidadinternal.util.JsonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateRestrictionValidator
extends org.apache.myfaces.trinidad.validator.DateRestrictionValidator
implements ClientValidator {
    private static final Collection<String> _IMPORT_NAMES = Collections.singletonList("TrNumberConverter()");

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (value == null) {
            return;
        }
        if (!(value instanceof Date)) {
            GenericConverterFactory fac = GenericConverterFactory.getCurrentInstance();
            value = fac.convert(value, Date.class);
        }
        super.validate(context, component, value);
    }

    public Collection<String> getClientImportNames() {
        return _IMPORT_NAMES;
    }

    public String getClientScript(FacesContext context, UIComponent component) {
        return null;
    }

    public String getClientValidation(FacesContext context, UIComponent component) {
        String[] weekdaysValue = this.getInvalidDaysOfWeek();
        String weekdaysValues = null;
        StringBuilder sb1 = new StringBuilder();
        String[] monthValue = this.getInvalidMonths();
        String monthValues = null;
        StringBuilder sb2 = new StringBuilder();
        monthValues = sb2.toString();
        try {
            JsonUtils.writeObject(sb1, weekdaysValue, false);
            weekdaysValues = sb1.toString();
            JsonUtils.writeObject(sb2, monthValue, false);
            monthValues = sb2.toString();
        }
        catch (IOException e) {
            weekdaysValues = "null";
            monthValues = "null";
        }
        String messageDetailDaysOfWeek = this.getMessageDetailInvalidDaysOfWeek();
        String messageDetailMonth = this.getMessageDetailInvalidMonths();
        String hintWeek = this.getHintInvalidDaysOfWeek();
        String hintMonth = this.getHintInvalidMonths();
        HashMap<String, String> cMessages = null;
        if (messageDetailDaysOfWeek != null || messageDetailMonth != null || hintWeek != null || hintMonth != null) {
            cMessages = new HashMap<String, String>();
            cMessages.put("days", messageDetailDaysOfWeek);
            cMessages.put("month", messageDetailMonth);
            cMessages.put("hintWeek", hintWeek);
            cMessages.put("hintMonth", hintMonth);
        }
        return DateRestrictionValidator._getTrDateRestrictionValidator(context, component, weekdaysValues, monthValues, cMessages);
    }

    public String getClientLibrarySource(FacesContext context) {
        return null;
    }

    private static String _getTrDateRestrictionValidator(FacesContext context, UIComponent component, String weekdaysValues, String monthValues, Map<String, String> messages) {
        StringBuilder outBuffer = new StringBuilder(31 + weekdaysValues.length() + monthValues.length());
        outBuffer.append("new TrDateRestrictionValidator(");
        outBuffer.append(weekdaysValues);
        outBuffer.append(',');
        outBuffer.append(monthValues);
        outBuffer.append(',');
        if (messages == null) {
            outBuffer.append("null");
        } else {
            try {
                JsonUtils.writeMap(outBuffer, messages, false);
            }
            catch (IOException e) {
                outBuffer.append("null");
            }
        }
        outBuffer.append(')');
        return outBuffer.toString();
    }
}

