/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.cache;

import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.cache.CacheEntry;

class Cache {
    private ConcurrentHashMap<Object, CacheEntry> _cache;
    private Hashtable<String, Boolean> _names = new Hashtable(101);
    private static final int _CACHE_SIZE = 101;
    private static final int _NAMES_SIZE = 101;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(Cache.class);

    public Cache() {
        this._cache = new ConcurrentHashMap(101);
    }

    public CacheEntry get(ImageContext context, Object key) {
        CacheEntry entry = this._cache.get(key);
        if (entry == null) {
            return null;
        }
        TrinidadAgent agent = context.getAgent();
        boolean capGif = false;
        Object capability = agent.getCapability(TrinidadAgent.CAP_GIF_TYPE_IMAGE);
        if (capability == Boolean.TRUE) {
            capGif = true;
        }
        boolean capPng = false;
        capability = agent.getCapability(TrinidadAgent.CAP_PNG_TYPE_IMAGE);
        if (capability == Boolean.TRUE) {
            capPng = true;
        }
        if (this._supportsEncoding(entry, capGif, capPng)) {
            return entry;
        }
        while ((entry = entry.getNext()) != null) {
            if (!this._supportsEncoding(entry, capGif, capPng)) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(ImageContext context, Object key, CacheEntry entry) {
        String baseName = this._getBaseName(entry.getImageURI());
        if (baseName != null) {
            this._names.put(baseName.toLowerCase(), Boolean.TRUE);
        }
        ConcurrentHashMap<Object, CacheEntry> concurrentHashMap = this._cache;
        synchronized (concurrentHashMap) {
            CacheEntry topEntry = this._cache.get(key);
            if (topEntry == null) {
                this._cache.put(key, entry);
            } else if (Cache._isMissRetryEntry(entry)) {
                CacheEntry nextEntry = null;
                while ((nextEntry = topEntry.getNext()) != null) {
                    topEntry = nextEntry;
                }
                if (!Cache._isMissRetryEntry(topEntry)) {
                    topEntry.setNext(entry);
                }
            } else {
                entry.setNext(topEntry);
                this._cache.put(key, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ImageContext context, Object key, CacheEntry entry) {
        ConcurrentHashMap<Object, CacheEntry> concurrentHashMap = this._cache;
        synchronized (concurrentHashMap) {
            CacheEntry topEntry = this._cache.get(key);
            if (topEntry == entry) {
                this._cache.remove(key);
                CacheEntry nextEntry = entry.getNext();
                if (nextEntry != null) {
                    this._cache.put(key, nextEntry);
                    entry.setNext(null);
                }
            } else if (topEntry != null) {
                CacheEntry nextEntry = null;
                while ((nextEntry = topEntry.getNext()) != null) {
                    if (nextEntry == entry) {
                        topEntry.setNext(entry.getNext());
                        entry.setNext(null);
                    }
                    topEntry = nextEntry;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getUniqueName(String baseName) {
        baseName = this._filterName(baseName);
        String lowerBaseName = baseName.toLowerCase();
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            String name = i == 0 ? lowerBaseName : lowerBaseName + "-" + i;
            Hashtable<String, Boolean> hashtable = this._names;
            synchronized (hashtable) {
                if (!this._names.containsKey(name)) {
                    this._names.put(name, Boolean.TRUE);
                    return i == 0 ? baseName : baseName + "-" + i;
                }
                continue;
            }
        }
        _LOG.severe("CANNOT_GET_UNIQUE_NAME");
        return null;
    }

    public synchronized void releaseUniqueName(String uniqueName) {
        this._names.remove(uniqueName.toLowerCase());
    }

    private String _filterName(String name) {
        StringBuffer buffer = null;
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (this._isValidCharacter(c)) {
                if (buffer == null) continue;
                buffer.append(c);
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuffer(length);
                buffer.append(name.substring(0, i));
            }
            buffer.append(this._getValidCharacter(c));
        }
        if (buffer != null) {
            return buffer.toString();
        }
        return name;
    }

    private boolean _isValidCharacter(char c) {
        return c >= 'A' && c < '[' || c >= 'a' && c < '{' || c >= '0' && c < ':' || c == '_' || c == '-';
    }

    private char _getValidCharacter(char c) {
        if (c == ' ') {
            return '_';
        }
        String hex = Integer.toHexString(c);
        return hex.charAt(hex.length() - 1);
    }

    private String _getBaseName(String uri) {
        if (uri == null) {
            return null;
        }
        int startIndex = uri.indexOf(47);
        int endIndex = uri.indexOf(46);
        assert (endIndex != -1);
        return uri.substring(startIndex == -1 ? 0 : startIndex + 1, endIndex);
    }

    private boolean _supportsEncoding(CacheEntry entry, boolean capGif, boolean capPng) {
        if (Cache._isMissRetryEntry(entry)) {
            return true;
        }
        String encoding = entry.getEncoding();
        return encoding == "image/gif" && capGif || encoding == "image/png" && capPng;
    }

    private static boolean _isMissRetryEntry(CacheEntry entry) {
        return entry.getImageURI() == null;
    }
}

