/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;
import org.apache.myfaces.tobago.ajax.AjaxUtils;
import org.apache.myfaces.tobago.application.ProjectStage;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Capability;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.internal.webapp.DebugResponseWriterWrapper;
import org.apache.myfaces.tobago.internal.webapp.HtmlResponseWriter;
import org.apache.myfaces.tobago.internal.webapp.JsonResponseWriter;
import org.apache.myfaces.tobago.internal.webapp.XmlResponseWriter;
import org.apache.myfaces.tobago.renderkit.RendererBaseWrapper;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TobagoRenderKit
extends RenderKit {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoRenderKit.class);
    public static final String RENDER_KIT_ID = "tobago";
    private RenderKit htmlBasicRenderKit;
    private Map<Key, Renderer> renderers = new HashMap<Key, Renderer>();

    public TobagoRenderKit() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating TobagoRenderKit");
        }
    }

    public Renderer getRenderer(String family, String rendererType) {
        RenderKit renderKit;
        Renderer renderer = this.renderers.get(new Key(family, rendererType));
        if (renderer == null && (renderer = (renderKit = this.getHtmlBasicRenderKit()).getRenderer(family, rendererType)) != null) {
            renderer = new RendererBaseWrapper(renderer);
        }
        if (renderer == null) {
            LOG.error("The class which was found by the ResourceManager cannot be found or instantiated: classname='" + rendererType + "'");
        }
        return renderer;
    }

    private RenderKit getHtmlBasicRenderKit() {
        if (this.htmlBasicRenderKit == null) {
            RenderKitFactory rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            this.htmlBasicRenderKit = rkFactory.getRenderKit(FacesContext.getCurrentInstance(), "HTML_BASIC");
        }
        return this.htmlBasicRenderKit;
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeList, String characterEncoding) {
        String contentType;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (AjaxUtils.isAjaxRequest(facesContext)) {
            return new JsonResponseWriter(writer, "application/json", characterEncoding);
        }
        if (contentTypeList == null) {
            contentType = "text/html";
        } else if (contentTypeList.indexOf("text/html") > -1) {
            contentType = "text/html";
            LOG.warn("patching content type from " + contentTypeList + " to " + contentType + "'");
        } else if (contentTypeList.indexOf("text/fo") > -1) {
            contentType = "text/fo";
            LOG.warn("patching content type from " + contentTypeList + " to " + contentType + "'");
        } else {
            if (contentTypeList.indexOf("application/json") > -1) {
                return new JsonResponseWriter(writer, "application/json", characterEncoding);
            }
            contentType = "text/html";
            LOG.warn("Content-Type '" + contentTypeList + "' not supported! Using text/html");
        }
        boolean xml = false;
        if ("application/xhtml+xml".equals(contentType) || "application/xhtml".equals(contentType) || "application/xml".equals(contentType) || "text/xml".equals(contentType)) {
            xml = true;
        }
        if (!ClientProperties.getInstance(FacesContext.getCurrentInstance()).getUserAgent().hasCapability(Capability.CONTENT_TYPE_XHTML)) {
            contentType = "text/html";
        }
        TobagoResponseWriter responseWriter = xml ? new XmlResponseWriter(writer, contentType, characterEncoding) : new HtmlResponseWriter(writer, contentType, characterEncoding);
        if (TobagoConfig.getInstance(facesContext).getProjectStage() == ProjectStage.Development) {
            responseWriter = new DebugResponseWriterWrapper(responseWriter);
        }
        return responseWriter;
    }

    public void addRenderer(String family, String rendererType, Renderer renderer) {
        this.renderers.put(new Key(family, rendererType), renderer);
    }

    public ResponseStateManager getResponseStateManager() {
        return this.getHtmlBasicRenderKit().getResponseStateManager();
    }

    public ResponseStream createResponseStream(OutputStream outputStream) {
        return this.getHtmlBasicRenderKit().createResponseStream(outputStream);
    }

    private static final class Key {
        private final String family;
        private final String rendererType;

        private Key(String family, String rendererType) {
            this.family = family;
            this.rendererType = rendererType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.family.equals(key.family)) {
                return false;
            }
            return this.rendererType.equals(key.rendererType);
        }

        public int hashCode() {
            int result = this.family.hashCode();
            result = 31 * result + this.rendererType.hashCode();
            return result;
        }
    }
}

