/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.conversation.spring;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.myfaces.orchestra.conversation.Conversation;
import org.apache.myfaces.orchestra.conversation.spring.PersistenceContext;
import org.apache.myfaces.orchestra.conversation.spring.PersistenceContextCloser;
import org.apache.myfaces.orchestra.conversation.spring.PersistenceContextFactory;

public class PersistenceContextConversationInterceptor
implements MethodInterceptor {
    private static final String PERSISTENCE_CONTEXT_CONV_ATTRIBUTE = PersistenceContextConversationInterceptor.class.getName() + ".PERSISTENCE_CONTEXT";
    public static final String REQUEST_ATTRIBUTE = PersistenceContextConversationInterceptor.class.getName() + ".USED_PERSISTENCE_CONTEXTS";
    private PersistenceContextFactory persistenceContextFactory;

    public void setPersistenceContextFactory(PersistenceContextFactory persistenceContextFactory) {
        this.persistenceContextFactory = persistenceContextFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        PersistenceContext persistenceContext = null;
        Conversation conversation = Conversation.getCurrentInstance();
        if (conversation != null) {
            PersistenceContextCloser persistenceContextCloser = (PersistenceContextCloser)conversation.getAttribute(PERSISTENCE_CONTEXT_CONV_ATTRIBUTE);
            if (persistenceContextCloser != null) {
                persistenceContext = persistenceContextCloser.getPersistenceContext();
            }
            if (persistenceContext == null) {
                persistenceContext = this.persistenceContextFactory.create();
                conversation.setAttribute(PERSISTENCE_CONTEXT_CONV_ATTRIBUTE, new PersistenceContextCloser(persistenceContext));
            }
        }
        if (persistenceContext != null) {
            persistenceContext.bind();
        }
        try {
            Object object = methodInvocation.proceed();
            return object;
        }
        finally {
            if (persistenceContext != null) {
                persistenceContext.unbind();
            }
        }
    }
}

