/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.crossval.strategy;

import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.validator.core.el.ELHelper;
import org.apache.myfaces.extensions.validator.core.el.ValueBindingExpression;
import org.apache.myfaces.extensions.validator.crossval.storage.CrossValidationStorage;
import org.apache.myfaces.extensions.validator.crossval.storage.CrossValidationStorageEntry;
import org.apache.myfaces.extensions.validator.crossval.storage.ProcessedInformationStorage;
import org.apache.myfaces.extensions.validator.crossval.storage.ProcessedInformationStorageEntry;
import org.apache.myfaces.extensions.validator.crossval.strategy.AbstractCompareStrategy;
import org.apache.myfaces.extensions.validator.crossval.strategy.CrossValidationHelper;
import org.apache.myfaces.extensions.validator.crossval.strategy.ReferencingStrategy;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.CrossValidationUtils;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

@UsageInformation(value={UsageCategory.INTERNAL})
class ELCompareStrategy
implements ReferencingStrategy {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    ELCompareStrategy() {
    }

    public boolean evaluateReferenceAndValidate(CrossValidationStorageEntry crossValidationStorageEntry, CrossValidationStorage crossValidationStorage, String validationTarget, AbstractCompareStrategy compareStrategy) {
        ELHelper elHelper = ExtValUtils.getELHelper();
        if (elHelper.isELTermWellFormed((Object)validationTarget) && elHelper.isELTermValid(FacesContext.getCurrentInstance(), validationTarget)) {
            this.tryToValidateValueBinding(crossValidationStorageEntry, new ValueBindingExpression(validationTarget), crossValidationStorage, compareStrategy);
            return true;
        }
        return false;
    }

    @ToDo(value=Priority.MEDIUM, description="test")
    protected boolean tryToValidateValueBinding(CrossValidationStorageEntry crossValidationStorageEntry, ValueBindingExpression validationTarget, CrossValidationStorage crossValidationStorage, AbstractCompareStrategy compareStrategy) {
        ProcessedInformationStorageEntry validationTargetEntry = this.resolveTargetForCrossComponentValidation(crossValidationStorageEntry, validationTarget);
        if (validationTargetEntry != null) {
            this.processCrossComponentValidation(compareStrategy, crossValidationStorageEntry, validationTargetEntry);
        } else {
            this.processModelAwareCrossValidation(compareStrategy, crossValidationStorageEntry, validationTarget);
        }
        return true;
    }

    private ProcessedInformationStorageEntry resolveTargetForCrossComponentValidation(CrossValidationStorageEntry crossValidationStorageEntry, ValueBindingExpression validationTarget) {
        ProcessedInformationStorage processedInformationStorage = CrossValidationUtils.getOrInitProcessedInformationStorage();
        return CrossValidationUtils.resolveValidationTargetEntry(processedInformationStorage, CrossValidationUtils.convertValueBindingExpressionToProcessedInformationKey(validationTarget), crossValidationStorageEntry);
    }

    private void processCrossComponentValidation(AbstractCompareStrategy compareStrategy, CrossValidationStorageEntry crossValidationStorageEntry, ProcessedInformationStorageEntry validationTargetEntry) {
        CrossValidationHelper.crossValidateCompareStrategy(compareStrategy, crossValidationStorageEntry, validationTargetEntry, false);
    }

    private void processModelAwareCrossValidation(AbstractCompareStrategy compareStrategy, CrossValidationStorageEntry crossValidationStorageEntry, ValueBindingExpression validationTarget) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Object targetValue = ExtValUtils.getELHelper().getValueOfExpression(facesContext, validationTarget);
        ProcessedInformationStorageEntry targetEntry = new ProcessedInformationStorageEntry();
        targetEntry.setBean(ExtValUtils.getELHelper().getValueOfExpression(facesContext, validationTarget.getBaseExpression()));
        targetEntry.setConvertedValue(targetValue);
        CrossValidationHelper.crossValidateCompareStrategy(compareStrategy, crossValidationStorageEntry, targetEntry, true);
    }
}

