/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.beanval.metadata.transformer;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.myfaces.extensions.validator.beanval.payload.DisableClientSideValidation;
import org.apache.myfaces.extensions.validator.beanval.payload.ViolationSeverity;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.metadata.transformer.MetaDataTransformer;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.REUSE})
public abstract class AbstractBeanValidationMetaDataTransformer<T extends Annotation>
implements MetaDataTransformer {
    public Map<String, Object> convertMetaData(MetaDataEntry metaDataEntry) {
        ConstraintDescriptor constraintDescriptor = (ConstraintDescriptor)metaDataEntry.getValue(ConstraintDescriptor.class);
        if (this.isClientSideValidationEnabled(constraintDescriptor) && this.isBlockingConstraint(constraintDescriptor)) {
            return this.transformMetaData(constraintDescriptor);
        }
        return Collections.emptyMap();
    }

    protected boolean isClientSideValidationEnabled(ConstraintDescriptor<? extends T> constraintDescriptor) {
        return !constraintDescriptor.getPayload().contains(ExtValUtils.getValidationParameterClassFor(DisableClientSideValidation.class));
    }

    protected boolean isBlockingConstraint(ConstraintDescriptor<?> constraintDescriptor) {
        FacesMessage testMessage = new FacesMessage();
        testMessage.setSeverity(ViolationSeverity.Error.VALUE);
        for (Class payload : constraintDescriptor.getPayload()) {
            if (ExtValUtils.getValidationParameterClassFor(ViolationSeverity.Warn.class).isAssignableFrom(payload)) {
                testMessage.setSeverity(ViolationSeverity.Warn.VALUE);
                continue;
            }
            if (ExtValUtils.getValidationParameterClassFor(ViolationSeverity.Info.class).isAssignableFrom(payload)) {
                testMessage.setSeverity(ViolationSeverity.Info.VALUE);
                continue;
            }
            if (!ExtValUtils.getValidationParameterClassFor(ViolationSeverity.Fatal.class).isAssignableFrom(payload)) continue;
            testMessage.setSeverity(ViolationSeverity.Fatal.VALUE);
        }
        return ExtValUtils.severityBlocksSubmitForComponentId(null, (FacesMessage)testMessage);
    }

    protected abstract Map<String, Object> transformMetaData(ConstraintDescriptor<T> var1);
}

