/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.openpgp;

import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.FilePasswordProviderManager;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.openpgp.PGPAuthorizedKeyEntriesLoader;
import org.apache.sshd.openpgp.PGPPublicKeyFileWatcher;
import org.apache.sshd.openpgp.PGPUtils;
import org.bouncycastle.openpgp.PGPException;
import org.c02e.jpgpj.Subkey;

public class PGPAuthorizedEntriesTracker
extends AbstractLoggingBean
implements PGPAuthorizedKeyEntriesLoader,
FilePasswordProviderManager {
    private FilePasswordProvider filePasswordProvider;
    private final List<PGPPublicKeyFileWatcher> keyFiles;

    public PGPAuthorizedEntriesTracker() {
        this(Collections.emptyList());
    }

    public PGPAuthorizedEntriesTracker(Path path) {
        this(path, null);
    }

    public PGPAuthorizedEntriesTracker(Path path, FilePasswordProvider passwordProvider) {
        this(Collections.singletonList(Objects.requireNonNull(path, "No path provided")), passwordProvider);
    }

    public PGPAuthorizedEntriesTracker(Collection<? extends Path> keys) {
        this(keys, null);
    }

    public PGPAuthorizedEntriesTracker(Collection<? extends Path> keys, FilePasswordProvider passwordProvider) {
        this.keyFiles = GenericUtils.isEmpty(keys) ? new ArrayList<PGPPublicKeyFileWatcher>() : (List)keys.stream().map(PGPPublicKeyFileWatcher::new).collect(Collectors.toCollection(() -> new ArrayList(keys.size())));
    }

    public FilePasswordProvider getFilePasswordProvider() {
        return this.filePasswordProvider;
    }

    public void setFilePasswordProvider(FilePasswordProvider filePasswordProvider) {
        this.filePasswordProvider = filePasswordProvider;
    }

    public List<PGPPublicKeyFileWatcher> getWatchedFiles() {
        return this.keyFiles;
    }

    public void addWatchedFile(Path p) {
        Objects.requireNonNull(p, "No file provided");
        List<PGPPublicKeyFileWatcher> files = this.getWatchedFiles();
        files.add(new PGPPublicKeyFileWatcher(p));
    }

    @Override
    public List<PublicKey> loadMatchingKeyFingerprints(SessionContext session, Collection<String> fingerprints) throws IOException, GeneralSecurityException, PGPException {
        int numEntries = GenericUtils.size(fingerprints);
        if (numEntries <= 0) {
            return Collections.emptyList();
        }
        List<PGPPublicKeyFileWatcher> files = this.getWatchedFiles();
        int numFiles = GenericUtils.size(files);
        if (numFiles <= 0) {
            return Collections.emptyList();
        }
        ArrayList<PublicKey> keys = new ArrayList<PublicKey>(Math.min(numEntries, numFiles));
        FilePasswordProvider provider = this.getFilePasswordProvider();
        boolean debugEnabled = this.log.isDebugEnabled();
        for (PGPPublicKeyFileWatcher f : files) {
            PathResource resourceKey;
            org.c02e.jpgpj.Key container = f.loadPublicKey(session, (NamedResource)(resourceKey = f.toPathResource()), provider);
            NavigableMap<String, Subkey> fpMap = PGPUtils.mapSubKeysByFingerprint(container);
            int numSubKeys = MapEntryUtils.size(fpMap);
            List<Subkey> matches = numSubKeys <= 0 ? Collections.emptyList() : (Collection)fpMap.entrySet().stream().filter(e -> fingerprints.contains(e.getKey())).map(Map.Entry::getValue).collect(Collectors.toCollection(() -> new ArrayList(numSubKeys)));
            int numMatches = GenericUtils.size(matches);
            if (debugEnabled) {
                this.log.debug("loadMatchingKeyFingerprints({}) found {}/{} matches in {}", new Object[]{session, numMatches, numEntries, resourceKey});
            }
            if (numMatches <= 0) continue;
            for (Subkey sk : matches) {
                PublicKey pk;
                try {
                    pk = this.extractPublicKey((NamedResource)resourceKey, sk);
                    if (pk == null) {
                        continue;
                    }
                }
                catch (IOException | RuntimeException | GeneralSecurityException e2) {
                    this.error("loadMatchingKeyFingerprints({}) failed ({}) to convert {} from {} to public key: {}", session, e2.getClass().getSimpleName(), sk, resourceKey, e2.getMessage(), e2);
                    throw e2;
                }
                if (debugEnabled) {
                    this.log.debug("loadMatchingKeyFingerprints({}) loaded key={}, fingerprint={}, hash={} from {}", new Object[]{session, KeyUtils.getKeyType((Key)pk), sk.getFingerprint(), KeyUtils.getFingerPrint((PublicKey)pk), resourceKey});
                }
                keys.add(pk);
            }
        }
        return keys;
    }

    @Override
    public <K extends PublicKey> K generatePublicKey(String algorithm, Class<K> keyType, KeySpec keySpec) throws GeneralSecurityException {
        KeyFactory factory = this.getKeyFactory(algorithm);
        PublicKey pubKey = factory.generatePublic(keySpec);
        return (K)((PublicKey)keyType.cast(pubKey));
    }

    protected KeyFactory getKeyFactory(String algorithm) throws GeneralSecurityException {
        return SecurityUtils.getKeyFactory((String)algorithm);
    }
}

