/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli.server.helper;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import org.apache.sshd.cli.server.helper.ServerEventListenerHelper;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.scp.common.ScpTransferEventListener;
import org.apache.sshd.scp.common.helpers.ScpAckInfo;
import org.slf4j.Logger;

public class ScpCommandTransferEventListener
extends ServerEventListenerHelper
implements ScpTransferEventListener {
    public ScpCommandTransferEventListener(Logger logger) {
        super("scp", logger);
    }

    public void startFileEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, long length, Set<PosixFilePermission> perms) throws IOException {
        if (this.log.isInfoEnabled()) {
            this.log.info("startFileEvent({})[{}] len={}, perms={}: {}", new Object[]{session, op, length, perms, file});
        }
    }

    public void endFileEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, long length, Set<PosixFilePermission> perms, Throwable thrown) throws IOException {
        if (thrown != null) {
            this.log.error("endFileEvent({})[{}] failed ({}) len={}, perms={} [{}]: {}", new Object[]{session, op, thrown.getClass().getSimpleName(), length, perms, file, thrown.getMessage()});
        } else if (this.log.isInfoEnabled()) {
            this.log.info("endFileEvent({})[{}] len={}, perms={}: {}", new Object[]{session, op, length, perms, file});
        }
    }

    public void startFolderEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, Set<PosixFilePermission> perms) throws IOException {
        if (this.log.isInfoEnabled()) {
            this.log.info("startFolderEvent({})[{}] perms={}: {}", new Object[]{session, op, perms, file});
        }
    }

    public void endFolderEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, Set<PosixFilePermission> perms, Throwable thrown) throws IOException {
        if (thrown != null) {
            this.log.error("endFolderEvent({})[{}] failed ({}) perms={} [{}]: {}", new Object[]{session, op, thrown.getClass().getSimpleName(), perms, file, thrown.getMessage()});
        } else if (this.log.isInfoEnabled()) {
            this.log.info("endFolderEvent({})[{}] perms={}: {}", new Object[]{session, op, perms, file});
        }
    }

    public void handleFileEventAckInfo(Session session, ScpTransferEventListener.FileOperation op, Path file, long length, Set<PosixFilePermission> perms, ScpAckInfo ackInfo) throws IOException {
        if (this.log.isInfoEnabled()) {
            this.log.info("handleFileEventAckInfo({})[{}] perms={}, length={}, ACK={}: {}", new Object[]{session, op, perms, length, ackInfo, file});
        }
    }
}

