/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.scp.common.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.scp.common.ScpFileOpener;
import org.apache.sshd.scp.common.ScpSourceStreamResolver;
import org.apache.sshd.scp.common.helpers.DefaultScpFileOpener;
import org.apache.sshd.scp.common.helpers.ScpTimestampCommandDetails;

public class LocalFileScpSourceStreamResolver
extends AbstractLoggingBean
implements ScpSourceStreamResolver {
    protected final Path path;
    protected final ScpFileOpener opener;
    protected final Path name;
    protected final Set<PosixFilePermission> perms;
    protected final long size;
    protected final ScpTimestampCommandDetails time;

    public LocalFileScpSourceStreamResolver(Path path, ScpFileOpener opener) throws IOException {
        this.path = Objects.requireNonNull(path, "No path specified");
        this.opener = opener == null ? DefaultScpFileOpener.INSTANCE : opener;
        this.name = path.getFileName();
        this.perms = IoUtils.getPermissions((Path)path, (LinkOption[])new LinkOption[0]);
        BasicFileAttributeView view = Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]);
        BasicFileAttributes basic = view.readAttributes();
        this.size = basic.size();
        this.time = new ScpTimestampCommandDetails(basic.lastModifiedTime().toMillis(), basic.lastAccessTime().toMillis());
    }

    @Override
    public String getFileName() throws IOException {
        return this.name.toString();
    }

    @Override
    public Collection<PosixFilePermission> getPermissions() throws IOException {
        return this.perms;
    }

    @Override
    public ScpTimestampCommandDetails getTimestamp() throws IOException {
        return this.time;
    }

    @Override
    public long getSize() throws IOException {
        return this.size;
    }

    @Override
    public Path getEventListenerFilePath() {
        return this.path;
    }

    @Override
    public InputStream resolveSourceStream(Session session, long length, Set<PosixFilePermission> permissions, OpenOption ... options) throws IOException {
        return this.opener.openRead(session, this.getEventListenerFilePath(), length, permissions, options);
    }

    @Override
    public void closeSourceStream(Session session, long length, Set<PosixFilePermission> permissions, InputStream stream) throws IOException {
        this.opener.closeRead(session, this.getEventListenerFilePath(), length, permissions, stream);
    }

    public String toString() {
        return String.valueOf(this.getEventListenerFilePath());
    }
}

