/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.apache.maven.lifecycle.internal.PhaseExecutionPoint;

public class PhaseId {
    private static final Map<String, PhaseId> INSTANCES = new WeakHashMap<String, PhaseId>();
    private final PhaseExecutionPoint executionPoint;
    private final String phase;
    private final int priority;

    public static synchronized PhaseId of(String phase) {
        return INSTANCES.computeIfAbsent(phase, PhaseId::new);
    }

    private PhaseId(String phase) {
        int phaseStart;
        if (phase.startsWith(PhaseExecutionPoint.BEFORE.prefix())) {
            this.executionPoint = PhaseExecutionPoint.BEFORE;
            phaseStart = PhaseExecutionPoint.BEFORE.prefix().length();
        } else if (phase.startsWith(PhaseExecutionPoint.AFTER.prefix())) {
            this.executionPoint = PhaseExecutionPoint.AFTER;
            phaseStart = PhaseExecutionPoint.AFTER.prefix().length();
        } else {
            this.executionPoint = PhaseExecutionPoint.AT;
            phaseStart = 0;
        }
        int phaseEnd = phase.indexOf(91);
        if (phaseEnd == -1) {
            this.priority = 0;
            this.phase = phase.substring(phaseStart);
        } else {
            boolean hasPriority;
            int priority;
            int priorityEnd = phase.lastIndexOf(93);
            if (priorityEnd < phaseEnd + 1) {
                priority = 0;
                hasPriority = false;
            } else {
                try {
                    priority = Integer.parseInt(phase.substring(phaseEnd + 1, priorityEnd));
                    hasPriority = true;
                }
                catch (NumberFormatException e) {
                    priority = 0;
                    hasPriority = false;
                }
            }
            if (hasPriority) {
                this.phase = phase.substring(phaseStart, phaseEnd);
                this.priority = priority;
            } else {
                this.phase = phase.substring(phaseStart);
                this.priority = 0;
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhaseId phaseId = (PhaseId)o;
        return Objects.equals((Object)this.executionPoint(), (Object)phaseId.executionPoint()) && Objects.equals(this.phase(), phaseId.phase()) && Objects.equals(this.priority(), phaseId.priority());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.executionPoint(), this.phase(), this.priority()});
    }

    public String toString() {
        return this.executionPoint().prefix() + this.phase() + (String)(this.priority() != 0 ? "[" + this.priority() + "]" : "");
    }

    public PhaseExecutionPoint executionPoint() {
        return this.executionPoint;
    }

    public String phase() {
        return this.phase;
    }

    public int priority() {
        return this.priority;
    }
}

