/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvn.resident;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.api.cli.InvokerException;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.cling.invoker.mvn.MavenContext;
import org.apache.maven.cling.invoker.mvn.MavenInvoker;

public class ResidentMavenInvoker
extends MavenInvoker {
    private final ConcurrentHashMap<String, MavenContext> residentContext = new ConcurrentHashMap();

    public ResidentMavenInvoker(Lookup protoLookup) {
        super(protoLookup, null);
    }

    public void close() throws InvokerException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (MavenContext context : this.residentContext.values()) {
            try {
                context.doCloseContainer();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            InvokerException exception = new InvokerException("Could not cleanly shut down context pool");
            exceptions.forEach(arg_0 -> exception.addSuppressed(arg_0));
            throw exception;
        }
    }

    @Override
    protected MavenContext createContext(InvokerRequest invokerRequest) {
        MavenContext result = this.residentContext.computeIfAbsent("resident", k -> new MavenContext(invokerRequest, false));
        return this.copyIfDifferent(result, invokerRequest);
    }

    protected MavenContext copyIfDifferent(MavenContext mavenContext, InvokerRequest invokerRequest) {
        if (invokerRequest == mavenContext.invokerRequest) {
            return mavenContext;
        }
        MavenContext shadow = new MavenContext(invokerRequest, false);
        shadow.containerCapsule = mavenContext.containerCapsule;
        shadow.lookup = mavenContext.lookup;
        shadow.eventSpyDispatcher = mavenContext.eventSpyDispatcher;
        shadow.maven = mavenContext.maven;
        return shadow;
    }
}

