/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.repository;

import java.io.File;
import java.net.URI;

public final class RepositoryUriUtils {
    private RepositoryUriUtils() {
    }

    public static URI toUri(String repositoryUrl) {
        String protocol = RepositoryUriUtils.protocol(repositoryUrl);
        if ("file".equals(protocol) || protocol.isEmpty() || protocol.length() == 1 && Character.isLetter(protocol.charAt(0)) && Character.isUpperCase(protocol.charAt(0))) {
            return new File(RepositoryUriUtils.basedir(repositoryUrl)).toURI();
        }
        return URI.create(repositoryUrl);
    }

    private static String protocol(String url) {
        int pos = url.indexOf(":");
        if (pos == -1) {
            return "";
        }
        return url.substring(0, pos).trim();
    }

    private static String basedir(String url) {
        String protocol = RepositoryUriUtils.protocol(url);
        String retValue = !protocol.isEmpty() ? url.substring(protocol.length() + 1) : url;
        if ((retValue = RepositoryUriUtils.decode(retValue)).startsWith("//")) {
            if ((retValue = retValue.substring(2)).length() >= 2 && (retValue.charAt(1) == '|' || retValue.charAt(1) == ':')) {
                retValue = retValue.charAt(0) + ":" + retValue.substring(2);
            } else {
                int index = retValue.indexOf("/");
                if (index >= 0) {
                    retValue = retValue.substring(index + 1);
                }
                if (retValue.length() >= 2 && (retValue.charAt(1) == '|' || retValue.charAt(1) == ':')) {
                    retValue = retValue.charAt(0) + ":" + retValue.substring(2);
                } else if (index >= 0) {
                    retValue = "/" + retValue;
                }
            }
        }
        if (retValue.length() >= 2 && retValue.charAt(1) == '|') {
            retValue = retValue.charAt(0) + ":" + retValue.substring(2);
        }
        return retValue.trim();
    }

    private static String decode(String url) {
        String decoded = url;
        if (url != null) {
            int pos = -1;
            while ((pos = decoded.indexOf(37, pos + 1)) >= 0) {
                if (pos + 2 >= decoded.length()) continue;
                String hexStr = decoded.substring(pos + 1, pos + 3);
                char ch = (char)Integer.parseInt(hexStr, 16);
                decoded = decoded.substring(0, pos) + ch + decoded.substring(pos + 3);
            }
        }
        return decoded;
    }
}

