/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.version;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.version.Version;

public final class PredicateVersionFilter
implements VersionFilter {
    private final Predicate<Artifact> artifactPredicate;

    public PredicateVersionFilter(Predicate<Artifact> artifactPredicate) {
        this.artifactPredicate = Objects.requireNonNull(artifactPredicate);
    }

    public void filterVersions(VersionFilter.VersionFilterContext context) {
        Artifact dependencyArtifact = context.getDependency().getArtifact();
        Iterator it = context.iterator();
        while (it.hasNext()) {
            Version version = (Version)it.next();
            if (this.artifactPredicate.test(dependencyArtifact.setVersion(version.toString()))) continue;
            it.remove();
        }
    }

    public VersionFilter deriveChildFilter(DependencyCollectionContext context) {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredicateVersionFilter that = (PredicateVersionFilter)o;
        return Objects.equals(this.artifactPredicate, that.artifactPredicate);
    }

    public int hashCode() {
        return Objects.hash(this.artifactPredicate);
    }
}

