/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class StringDigestUtil {
    private final MessageDigest digest;

    public StringDigestUtil(String alg) {
        try {
            this.digest = MessageDigest.getInstance(alg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Not supported digest algorithm: " + alg);
        }
    }

    public StringDigestUtil update(String data) {
        if (data != null && !data.isEmpty()) {
            this.digest.update(data.getBytes(StandardCharsets.UTF_8));
        }
        return this;
    }

    public String digest() {
        return StringDigestUtil.toHexString(this.digest.digest());
    }

    public static StringDigestUtil sha1() {
        return new StringDigestUtil("SHA-1");
    }

    public static String sha1(String string) {
        return StringDigestUtil.sha1().update(string).digest();
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(bytes.length * 2);
        for (byte aByte : bytes) {
            int b = aByte & 0xFF;
            if (b < 16) {
                buffer.append('0');
            }
            buffer.append(Integer.toHexString(b));
        }
        return buffer.toString();
    }

    public static byte[] fromHexString(String hexString) {
        if (hexString == null) {
            return null;
        }
        if (hexString.isEmpty()) {
            return new byte[0];
        }
        int len = hexString.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("hexString length not even");
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }
}

