/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.crypto;

import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.building.DefaultSettingsProblem;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionResult;
import org.apache.maven.settings.crypto.MavenSecDispatcher;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.components.secdispatcher.SecDispatcher;
import org.codehaus.plexus.components.secdispatcher.SecDispatcherException;

@Named
@Singleton
@Deprecated(since="4.0.0")
public class DefaultSettingsDecrypter
implements SettingsDecrypter {
    private final SecDispatcher securityDispatcher;

    @Inject
    public DefaultSettingsDecrypter(MavenSecDispatcher securityDispatcher) {
        this.securityDispatcher = securityDispatcher;
    }

    @Override
    public SettingsDecryptionResult decrypt(SettingsDecryptionRequest request) {
        ArrayList<SettingsProblem> problems = new ArrayList<SettingsProblem>();
        ArrayList<Server> servers = new ArrayList<Server>();
        for (Server server : request.getServers()) {
            String passphrase;
            String password = (server = server.clone()).getPassword();
            if (this.securityDispatcher.isAnyEncryptedString(password)) {
                try {
                    if (this.securityDispatcher.isLegacyEncryptedString(password)) {
                        problems.add(new DefaultSettingsProblem("Pre-Maven 4 legacy encrypted password detected for server " + server.getId() + " - configure password encryption with the help of mvnenc to be compatible with Maven 4.", SettingsProblem.Severity.WARNING, "server: " + server.getId(), -1, -1, null));
                    }
                    server.setPassword(this.securityDispatcher.decrypt(password));
                }
                catch (IOException | SecDispatcherException e) {
                    problems.add(new DefaultSettingsProblem("Failed to decrypt password for server " + server.getId() + ": " + e.getMessage(), SettingsProblem.Severity.ERROR, "server: " + server.getId(), -1, -1, (Exception)e));
                }
            }
            if (this.securityDispatcher.isAnyEncryptedString(passphrase = server.getPassphrase())) {
                try {
                    if (this.securityDispatcher.isLegacyEncryptedString(passphrase)) {
                        problems.add(new DefaultSettingsProblem("Legacy/insecurely encrypted passphrase detected for server " + server.getId(), SettingsProblem.Severity.WARNING, "server: " + server.getId(), -1, -1, null));
                    }
                    server.setPassphrase(this.securityDispatcher.decrypt(passphrase));
                }
                catch (IOException | SecDispatcherException e) {
                    problems.add(new DefaultSettingsProblem("Failed to decrypt passphrase for server " + server.getId() + ": " + e.getMessage(), SettingsProblem.Severity.ERROR, "server: " + server.getId(), -1, -1, (Exception)e));
                }
            }
            servers.add(server);
        }
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        for (Proxy proxy : request.getProxies()) {
            String password = proxy.getPassword();
            if (this.securityDispatcher.isAnyEncryptedString(password)) {
                try {
                    if (this.securityDispatcher.isLegacyEncryptedString(password)) {
                        problems.add(new DefaultSettingsProblem("Legacy/insecurely encrypted password detected for proxy " + proxy.getId(), SettingsProblem.Severity.WARNING, "proxy: " + proxy.getId(), -1, -1, null));
                    }
                    proxy.setPassword(this.securityDispatcher.decrypt(password));
                }
                catch (IOException | SecDispatcherException e) {
                    problems.add(new DefaultSettingsProblem("Failed to decrypt password for proxy " + proxy.getId() + ": " + e.getMessage(), SettingsProblem.Severity.ERROR, "proxy: " + proxy.getId(), -1, -1, (Exception)e));
                }
            }
            proxies.add(proxy);
        }
        return new DefaultSettingsDecryptionResult(servers, proxies, problems);
    }
}

