/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.services.BaseRequest;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.ModelTransformer;
import org.apache.maven.api.services.Request;
import org.apache.maven.api.services.RequestTrace;
import org.apache.maven.api.services.Sources;

@Experimental
@Immutable
public interface ModelBuilderRequest
extends Request<Session> {
    @Nonnull
    public ModelSource getSource();

    @Nonnull
    public RequestType getRequestType();

    public boolean isLocationTracking();

    public boolean isRecursive();

    @Nonnull
    public Collection<Profile> getProfiles();

    @Nonnull
    public List<String> getActiveProfileIds();

    @Nonnull
    public List<String> getInactiveProfileIds();

    @Nonnull
    public Map<String, String> getSystemProperties();

    @Nonnull
    public Map<String, String> getUserProperties();

    @Nonnull
    public RepositoryMerging getRepositoryMerging();

    @Nullable
    public List<RemoteRepository> getRepositories();

    @Nullable
    public ModelTransformer getLifecycleBindingsInjector();

    @Nonnull
    public static ModelBuilderRequest build(@Nonnull ModelBuilderRequest request, @Nonnull ModelSource source) {
        return ModelBuilderRequest.builder(Objects.requireNonNull(request, "request cannot be null")).source(Objects.requireNonNull(source, "source cannot be null")).build();
    }

    @Nonnull
    public static ModelBuilderRequest build(@Nonnull Session session, @Nonnull ModelSource source) {
        return ModelBuilderRequest.builder().session(Objects.requireNonNull(session, "session cannot be null")).source(Objects.requireNonNull(source, "source cannot be null")).build();
    }

    @Nonnull
    public static ModelBuilderRequest build(@Nonnull Session session, @Nonnull Path path) {
        return ModelBuilderRequest.builder().session(Objects.requireNonNull(session, "session cannot be null")).source(Sources.buildSource(path)).build();
    }

    @Nonnull
    public static ModelBuilderRequestBuilder builder() {
        return new ModelBuilderRequestBuilder();
    }

    @Nonnull
    public static ModelBuilderRequestBuilder builder(ModelBuilderRequest request) {
        return new ModelBuilderRequestBuilder(request);
    }

    @NotThreadSafe
    public static class ModelBuilderRequestBuilder {
        Session session;
        RequestTrace trace;
        RequestType requestType;
        boolean locationTracking;
        boolean recursive;
        ModelSource source;
        Collection<Profile> profiles;
        List<String> activeProfileIds;
        List<String> inactiveProfileIds;
        Map<String, String> systemProperties;
        Map<String, String> userProperties;
        RepositoryMerging repositoryMerging;
        List<RemoteRepository> repositories;
        ModelTransformer lifecycleBindingsInjector;

        ModelBuilderRequestBuilder() {
        }

        ModelBuilderRequestBuilder(ModelBuilderRequest request) {
            this.session = (Session)request.getSession();
            this.trace = request.getTrace();
            this.requestType = request.getRequestType();
            this.locationTracking = request.isLocationTracking();
            this.recursive = request.isRecursive();
            this.source = request.getSource();
            this.profiles = request.getProfiles();
            this.activeProfileIds = request.getActiveProfileIds();
            this.inactiveProfileIds = request.getInactiveProfileIds();
            this.systemProperties = request.getSystemProperties();
            this.userProperties = request.getUserProperties();
            this.repositoryMerging = request.getRepositoryMerging();
            this.repositories = request.getRepositories();
            this.lifecycleBindingsInjector = request.getLifecycleBindingsInjector();
        }

        public ModelBuilderRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        public ModelBuilderRequestBuilder trace(RequestTrace trace) {
            this.trace = trace;
            return this;
        }

        public ModelBuilderRequestBuilder requestType(RequestType requestType) {
            this.requestType = requestType;
            return this;
        }

        public ModelBuilderRequestBuilder locationTracking(boolean locationTracking) {
            this.locationTracking = locationTracking;
            return this;
        }

        public ModelBuilderRequestBuilder recursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public ModelBuilderRequestBuilder source(ModelSource source) {
            this.source = source;
            return this;
        }

        public ModelBuilderRequestBuilder profiles(List<Profile> profiles) {
            this.profiles = profiles;
            return this;
        }

        public ModelBuilderRequestBuilder activeProfileIds(List<String> activeProfileIds) {
            this.activeProfileIds = activeProfileIds;
            return this;
        }

        public ModelBuilderRequestBuilder inactiveProfileIds(List<String> inactiveProfileIds) {
            this.inactiveProfileIds = inactiveProfileIds;
            return this;
        }

        public ModelBuilderRequestBuilder systemProperties(Map<String, String> systemProperties) {
            this.systemProperties = systemProperties;
            return this;
        }

        public ModelBuilderRequestBuilder userProperties(Map<String, String> userProperties) {
            this.userProperties = userProperties;
            return this;
        }

        public ModelBuilderRequestBuilder repositoryMerging(RepositoryMerging repositoryMerging) {
            this.repositoryMerging = repositoryMerging;
            return this;
        }

        public ModelBuilderRequestBuilder repositories(List<RemoteRepository> repositories) {
            this.repositories = repositories;
            return this;
        }

        public ModelBuilderRequestBuilder lifecycleBindingsInjector(ModelTransformer lifecycleBindingsInjector) {
            this.lifecycleBindingsInjector = lifecycleBindingsInjector;
            return this;
        }

        public ModelBuilderRequest build() {
            return new DefaultModelBuilderRequest(this.session, this.trace, this.requestType, this.locationTracking, this.recursive, this.source, this.profiles, this.activeProfileIds, this.inactiveProfileIds, this.systemProperties, this.userProperties, this.repositoryMerging, this.repositories, this.lifecycleBindingsInjector);
        }

        private static class DefaultModelBuilderRequest
        extends BaseRequest<Session>
        implements ModelBuilderRequest {
            private final RequestType requestType;
            private final boolean locationTracking;
            private final boolean recursive;
            private final ModelSource source;
            private final Collection<Profile> profiles;
            private final List<String> activeProfileIds;
            private final List<String> inactiveProfileIds;
            private final Map<String, String> systemProperties;
            private final Map<String, String> userProperties;
            private final RepositoryMerging repositoryMerging;
            private final List<RemoteRepository> repositories;
            private final ModelTransformer lifecycleBindingsInjector;

            DefaultModelBuilderRequest(@Nonnull Session session, @Nullable RequestTrace trace, @Nonnull RequestType requestType, boolean locationTracking, boolean recursive, @Nonnull ModelSource source, Collection<Profile> profiles, List<String> activeProfileIds, List<String> inactiveProfileIds, Map<String, String> systemProperties, Map<String, String> userProperties, RepositoryMerging repositoryMerging, List<RemoteRepository> repositories, ModelTransformer lifecycleBindingsInjector) {
                super(session, trace);
                this.requestType = Objects.requireNonNull(requestType, "requestType cannot be null");
                this.locationTracking = locationTracking;
                this.recursive = recursive;
                this.source = source;
                this.profiles = profiles != null ? List.copyOf(profiles) : List.of();
                this.activeProfileIds = activeProfileIds != null ? List.copyOf(activeProfileIds) : List.of();
                this.inactiveProfileIds = inactiveProfileIds != null ? List.copyOf(inactiveProfileIds) : List.of();
                this.systemProperties = systemProperties != null ? Map.copyOf(systemProperties) : session.getSystemProperties();
                this.userProperties = userProperties != null ? Map.copyOf(userProperties) : session.getUserProperties();
                this.repositoryMerging = repositoryMerging;
                this.repositories = repositories != null ? List.copyOf(repositories) : null;
                this.lifecycleBindingsInjector = lifecycleBindingsInjector;
            }

            @Override
            public RequestType getRequestType() {
                return this.requestType;
            }

            @Override
            public boolean isLocationTracking() {
                return this.locationTracking;
            }

            @Override
            public boolean isRecursive() {
                return this.recursive;
            }

            @Override
            @Nonnull
            public ModelSource getSource() {
                return this.source;
            }

            @Override
            public Collection<Profile> getProfiles() {
                return this.profiles;
            }

            @Override
            public List<String> getActiveProfileIds() {
                return this.activeProfileIds;
            }

            @Override
            public List<String> getInactiveProfileIds() {
                return this.inactiveProfileIds;
            }

            @Override
            public Map<String, String> getSystemProperties() {
                return this.systemProperties;
            }

            @Override
            public Map<String, String> getUserProperties() {
                return this.userProperties;
            }

            @Override
            public RepositoryMerging getRepositoryMerging() {
                return this.repositoryMerging;
            }

            @Override
            public List<RemoteRepository> getRepositories() {
                return this.repositories;
            }

            @Override
            public ModelTransformer getLifecycleBindingsInjector() {
                return this.lifecycleBindingsInjector;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object o) {
                if (!(o instanceof DefaultModelBuilderRequest)) return false;
                DefaultModelBuilderRequest that = (DefaultModelBuilderRequest)o;
                if (this.locationTracking != that.locationTracking) return false;
                if (this.recursive != that.recursive) return false;
                if (this.requestType != that.requestType) return false;
                if (!Objects.equals(this.source, that.source)) return false;
                if (!Objects.equals(this.profiles, that.profiles)) return false;
                if (!Objects.equals(this.activeProfileIds, that.activeProfileIds)) return false;
                if (!Objects.equals(this.inactiveProfileIds, that.inactiveProfileIds)) return false;
                if (!Objects.equals(this.systemProperties, that.systemProperties)) return false;
                if (!Objects.equals(this.userProperties, that.userProperties)) return false;
                if (this.repositoryMerging != that.repositoryMerging) return false;
                if (!Objects.equals(this.repositories, that.repositories)) return false;
                if (!Objects.equals(this.lifecycleBindingsInjector, that.lifecycleBindingsInjector)) return false;
                return true;
            }

            @Override
            public int hashCode() {
                return Objects.hash(new Object[]{this.requestType, this.locationTracking, this.recursive, this.source, this.profiles, this.activeProfileIds, this.inactiveProfileIds, this.systemProperties, this.userProperties, this.repositoryMerging, this.repositories, this.lifecycleBindingsInjector});
            }

            @Override
            public String toString() {
                return "ModelBuilderRequest[requestType=" + String.valueOf((Object)this.requestType) + ", locationTracking=" + this.locationTracking + ", recursive=" + this.recursive + ", source=" + String.valueOf(this.source) + ", profiles=" + String.valueOf(this.profiles) + ", activeProfileIds=" + String.valueOf(this.activeProfileIds) + ", inactiveProfileIds=" + String.valueOf(this.inactiveProfileIds) + ", systemProperties=" + String.valueOf(this.systemProperties) + ", userProperties=" + String.valueOf(this.userProperties) + ", repositoryMerging=" + String.valueOf((Object)this.repositoryMerging) + ", repositories=" + String.valueOf(this.repositories) + ", lifecycleBindingsInjector=" + String.valueOf(this.lifecycleBindingsInjector) + "]";
            }
        }
    }

    public static enum RepositoryMerging {
        POM_DOMINANT,
        REQUEST_DOMINANT;

    }

    public static enum RequestType {
        BUILD_PROJECT,
        BUILD_EFFECTIVE,
        BUILD_CONSUMER,
        CONSUMER_PARENT,
        CONSUMER_DEPENDENCY;

    }
}

