/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.maven.api.ProducedArtifact;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BaseRequest;
import org.apache.maven.api.services.Request;
import org.apache.maven.api.services.RequestTrace;

@Experimental
@Immutable
public interface ArtifactDeployerRequest
extends Request<Session> {
    @Nonnull
    public RemoteRepository getRepository();

    @Nonnull
    public Collection<ProducedArtifact> getArtifacts();

    public int getRetryFailedDeploymentCount();

    @Nonnull
    public static ArtifactDeployerRequestBuilder builder() {
        return new ArtifactDeployerRequestBuilder();
    }

    @Nonnull
    public static ArtifactDeployerRequest build(@Nonnull Session session, @Nonnull RemoteRepository repository, @Nonnull Collection<ProducedArtifact> artifacts) {
        return ArtifactDeployerRequest.builder().session(Objects.requireNonNull(session, "session cannot be null")).repository(Objects.requireNonNull(repository, "repository cannot be null")).artifacts(Objects.requireNonNull(artifacts, "artifacts cannot be null")).build();
    }

    public static class ArtifactDeployerRequestBuilder {
        Session session;
        RequestTrace trace;
        RemoteRepository repository;
        Collection<ProducedArtifact> artifacts;
        int retryFailedDeploymentCount;

        ArtifactDeployerRequestBuilder() {
        }

        @Nonnull
        public ArtifactDeployerRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        @Nonnull
        public ArtifactDeployerRequestBuilder trace(RequestTrace trace) {
            this.trace = trace;
            return this;
        }

        @Nonnull
        public ArtifactDeployerRequestBuilder repository(RemoteRepository repository) {
            this.repository = repository;
            return this;
        }

        public ArtifactDeployerRequestBuilder artifacts(Collection<ProducedArtifact> artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public ArtifactDeployerRequestBuilder retryFailedDeploymentCount(int retryFailedDeploymentCount) {
            this.retryFailedDeploymentCount = retryFailedDeploymentCount;
            return this;
        }

        @Nonnull
        public ArtifactDeployerRequest build() {
            return new DefaultArtifactDeployerRequest(this.session, this.trace, this.repository, this.artifacts, this.retryFailedDeploymentCount);
        }

        private static class DefaultArtifactDeployerRequest
        extends BaseRequest<Session>
        implements ArtifactDeployerRequest {
            private final RemoteRepository repository;
            private final Collection<ProducedArtifact> artifacts;
            private final int retryFailedDeploymentCount;

            DefaultArtifactDeployerRequest(@Nonnull Session session, @Nullable RequestTrace trace, @Nonnull RemoteRepository repository, @Nonnull Collection<ProducedArtifact> artifacts, int retryFailedDeploymentCount) {
                super(session, trace);
                this.repository = Objects.requireNonNull(repository, "repository cannot be null");
                this.artifacts = List.copyOf(Objects.requireNonNull(artifacts, "artifacts cannot be null"));
                this.retryFailedDeploymentCount = retryFailedDeploymentCount;
            }

            @Override
            @Nonnull
            public RemoteRepository getRepository() {
                return this.repository;
            }

            @Override
            @Nonnull
            public Collection<ProducedArtifact> getArtifacts() {
                return this.artifacts;
            }

            @Override
            public int getRetryFailedDeploymentCount() {
                return this.retryFailedDeploymentCount;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object o) {
                if (!(o instanceof DefaultArtifactDeployerRequest)) return false;
                DefaultArtifactDeployerRequest that = (DefaultArtifactDeployerRequest)o;
                if (this.retryFailedDeploymentCount != that.retryFailedDeploymentCount) return false;
                if (!Objects.equals(this.repository, that.repository)) return false;
                if (!Objects.equals(this.artifacts, that.artifacts)) return false;
                return true;
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.repository, this.artifacts, this.retryFailedDeploymentCount);
            }

            @Override
            public String toString() {
                return "ArtifactDeployerRequest[repository=" + String.valueOf(this.repository) + ", artifacts=" + String.valueOf(this.artifacts) + ", retryFailedDeploymentCount=" + this.retryFailedDeploymentCount + "]";
            }
        }
    }
}

