/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.internal.impl.DefaultLifecycleRegistry;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.LifeCyclePluginAnalyzer;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.lifecycle.mapping.LifecycleMojo;
import org.apache.maven.lifecycle.mapping.LifecyclePhase;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultLifecyclePluginAnalyzer
implements LifeCyclePluginAnalyzer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Lookup lookup;
    private final DefaultLifecycles defaultLifeCycles;

    @Inject
    public DefaultLifecyclePluginAnalyzer(Lookup lookup, DefaultLifecycles defaultLifeCycles) {
        this.lookup = Objects.requireNonNull(lookup);
        this.defaultLifeCycles = Objects.requireNonNull(defaultLifeCycles);
    }

    @Override
    public Set<Plugin> getPluginsBoundByDefaultToAllLifecycles(String packaging) {
        LifecycleMapping lifecycleMappingForPackaging;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Looking up lifecycle mappings for packaging " + packaging + " from " + String.valueOf(Thread.currentThread().getContextClassLoader()));
        }
        if ((lifecycleMappingForPackaging = this.lookupLifecycleMapping(packaging)) == null) {
            return null;
        }
        LinkedHashMap<Plugin, Plugin> plugins = new LinkedHashMap<Plugin, Plugin>();
        for (Lifecycle lifecycle : this.defaultLifeCycles.getLifeCycles()) {
            org.apache.maven.lifecycle.mapping.Lifecycle lifecycleConfiguration = lifecycleMappingForPackaging.getLifecycles().get(lifecycle.getId());
            Map<String, LifecyclePhase> phaseToGoalMapping = null;
            if (lifecycleConfiguration != null) {
                phaseToGoalMapping = lifecycleConfiguration.getLifecyclePhases();
            } else if (lifecycle.getDefaultLifecyclePhases() != null) {
                phaseToGoalMapping = lifecycle.getDefaultLifecyclePhases();
            }
            if (phaseToGoalMapping == null) continue;
            for (Map.Entry<String, LifecyclePhase> goalsForLifecyclePhase : phaseToGoalMapping.entrySet()) {
                String phase = goalsForLifecyclePhase.getKey();
                LifecyclePhase goals = goalsForLifecyclePhase.getValue();
                if (goals == null) continue;
                this.parseLifecyclePhaseDefinitions(plugins, phase, goals);
            }
        }
        return plugins.keySet();
    }

    private LifecycleMapping lookupLifecycleMapping(String packaging) {
        return this.lookup.lookupOptional(LifecycleMapping.class, packaging).orElse(null);
    }

    private void parseLifecyclePhaseDefinitions(Map<Plugin, Plugin> plugins, String phase, LifecyclePhase goals) {
        InputSource inputSource = new InputSource();
        inputSource.setModelId(DefaultLifecycleRegistry.DEFAULT_LIFECYCLE_MODELID);
        InputLocation location = new InputLocation(-1, -1, inputSource);
        location.setLocation((Object)0, location);
        List<LifecycleMojo> mojos = goals.getMojos();
        if (mojos != null) {
            for (int i = 0; i < mojos.size(); ++i) {
                LifecycleMojo mojo = mojos.get(i);
                GoalSpec gs = this.parseGoalSpec(mojo.getGoal());
                if (gs == null) {
                    this.logger.warn("Ignored invalid goal specification '{}' from lifecycle mapping for phase {}", (Object)mojo.getGoal(), (Object)phase);
                    continue;
                }
                Plugin plugin = new Plugin();
                plugin.setGroupId(gs.groupId);
                plugin.setArtifactId(gs.artifactId);
                plugin.setVersion(gs.version);
                plugin.setLocation((Object)"", location);
                plugin.setLocation((Object)"groupId", location);
                plugin.setLocation((Object)"artifactId", location);
                plugin.setLocation((Object)"version", location);
                Plugin existing = plugins.get(plugin);
                if (existing != null) {
                    if (existing.getVersion() == null) {
                        existing.setVersion(plugin.getVersion());
                        existing.setLocation((Object)"version", location);
                    }
                    plugin = existing;
                } else {
                    plugins.put(plugin, plugin);
                }
                PluginExecution execution = new PluginExecution();
                execution.setId(this.getExecutionId(plugin, gs.goal));
                execution.setPhase(phase);
                execution.setPriority(i - mojos.size());
                execution.getGoals().add(gs.goal);
                execution.setLocation((Object)"", location);
                execution.setLocation((Object)"id", location);
                execution.setLocation((Object)"phase", location);
                execution.setLocation((Object)"goals", location);
                XmlNode lifecycleConfiguration = mojo.getConfiguration();
                if (lifecycleConfiguration != null) {
                    execution.setConfiguration((Object)new Xpp3Dom(lifecycleConfiguration));
                }
                if (mojo.getDependencies() != null) {
                    plugin.setDependencies(mojo.getDependencies());
                }
                plugin.getExecutions().add(execution);
            }
        }
    }

    private GoalSpec parseGoalSpec(String goalSpec) {
        GoalSpec gs = new GoalSpec();
        String[] p = goalSpec.trim().split(":");
        if (p.length == 3) {
            gs.groupId = p[0];
            gs.artifactId = p[1];
            gs.goal = p[2];
        } else if (p.length == 4) {
            gs.groupId = p[0];
            gs.artifactId = p[1];
            gs.version = p[2];
            gs.goal = p[3];
        } else {
            gs = null;
        }
        return gs;
    }

    private String getExecutionId(Plugin plugin, String goal) {
        String base;
        HashSet<String> existingIds = new HashSet<String>();
        for (PluginExecution execution : plugin.getExecutions()) {
            existingIds.add(execution.getId());
        }
        String id = base = "default-" + goal;
        int index = 1;
        while (existingIds.contains(id)) {
            id = base + "-" + index;
            ++index;
        }
        return id;
    }

    static class GoalSpec {
        String groupId;
        String artifactId;
        String version;
        String goal;

        GoalSpec() {
        }
    }
}

