/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.extension.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.project.ExtensionDescriptor;
import org.apache.maven.project.ExtensionDescriptorBuilder;
import org.codehaus.plexus.classworlds.realm.ClassRealm;

public class CoreExtensionEntry {
    private final ClassRealm realm;
    private final Set<String> artifacts;
    private final Set<String> packages;
    private final String key;
    private final XmlNode configuration;
    private static final ExtensionDescriptorBuilder BUILDER = new ExtensionDescriptorBuilder();

    public CoreExtensionEntry(ClassRealm realm, Collection<String> artifacts, Collection<String> packages, String key, XmlNode configuration) {
        this.realm = realm;
        this.artifacts = Collections.unmodifiableSet(new HashSet<String>(artifacts));
        this.packages = Collections.unmodifiableSet(new HashSet<String>(packages));
        this.key = key;
        this.configuration = configuration;
    }

    public ClassRealm getClassRealm() {
        return this.realm;
    }

    public Set<String> getExportedArtifacts() {
        return this.artifacts;
    }

    public Set<String> getExportedPackages() {
        return this.packages;
    }

    public String getKey() {
        return this.key;
    }

    public XmlNode getConfiguration() {
        return this.configuration;
    }

    public static CoreExtensionEntry discoverFrom(ClassRealm loader) {
        LinkedHashSet<String> artifacts = new LinkedHashSet<String>();
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        try {
            Enumeration urls = loader.getResources(BUILDER.getExtensionDescriptorLocation());
            while (urls.hasMoreElements()) {
                InputStream is = ((URL)urls.nextElement()).openStream();
                try {
                    ExtensionDescriptor descriptor = BUILDER.build(is);
                    artifacts.addAll(descriptor.getExportedArtifacts());
                    packages.addAll(descriptor.getExportedPackages());
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new CoreExtensionEntry(loader, artifacts, packages, null, null);
    }

    public static CoreExtensionEntry discoverFrom(ClassRealm loader, Collection<File> classpath, String key, XmlNode configuration) {
        LinkedHashSet<String> artifacts = new LinkedHashSet<String>();
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        try {
            for (File entry : classpath) {
                ExtensionDescriptor descriptor = BUILDER.build(entry);
                if (descriptor == null) continue;
                artifacts.addAll(descriptor.getExportedArtifacts());
                packages.addAll(descriptor.getExportedPackages());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new CoreExtensionEntry(loader, artifacts, packages, key, configuration);
    }
}

