/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.cli;

import java.util.List;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;

@Experimental
public interface Logger {
    default public void log(@Nonnull Level level, @Nonnull String message) {
        this.log(level, message, null);
    }

    public void log(@Nonnull Level var1, @Nonnull String var2, @Nullable Throwable var3);

    default public void debug(String message) {
        this.log(Level.DEBUG, message);
    }

    default public void debug(@Nonnull String message, @Nullable Throwable error) {
        this.log(Level.DEBUG, message, error);
    }

    default public void info(@Nonnull String message) {
        this.log(Level.INFO, message);
    }

    default public void info(@Nonnull String message, @Nullable Throwable error) {
        this.log(Level.INFO, message, error);
    }

    default public void warn(@Nonnull String message) {
        this.log(Level.WARN, message);
    }

    default public void warn(@Nonnull String message, @Nullable Throwable error) {
        this.log(Level.WARN, message, error);
    }

    default public void error(@Nonnull String message) {
        this.log(Level.ERROR, message);
    }

    default public void error(@Nonnull String message, @Nullable Throwable error) {
        this.log(Level.ERROR, message, error);
    }

    @Nonnull
    default public List<Entry> drain() {
        return List.of();
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }

    public record Entry(@Nonnull Level level, @Nonnull String message, @Nullable Throwable error) {
    }
}

