/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Priority;
import org.apache.maven.api.di.Provides;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.di.Typed;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.services.ToolchainFactoryException;
import org.apache.maven.api.services.ToolchainManagerException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.impl.DefaultToolchainManager;
import org.apache.maven.impl.MappedList;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainFactory;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.ToolchainManagerPrivate;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.slf4j.Logger;

@Named
@Singleton
@Deprecated(since="4.0.0")
public class ToolchainManagerFactory {
    private final Lookup lookup;
    private final Logger logger;

    @Inject
    ToolchainManagerFactory(Lookup lookup) {
        this(lookup, null);
    }

    protected ToolchainManagerFactory(Lookup lookup, Logger logger) {
        this.lookup = lookup;
        this.logger = logger;
    }

    @Provides
    @Typed(value={ToolchainManager.class, ToolchainManagerPrivate.class})
    @Named
    DefaultToolchainManagerV3 v3Manager() {
        return new DefaultToolchainManagerV3();
    }

    @Provides
    @Priority(value=10)
    @Typed(value={org.apache.maven.api.services.ToolchainManager.class})
    DefaultToolchainManagerV4 v4Manager() {
        return new DefaultToolchainManagerV4();
    }

    private DefaultToolchainManager getDelegate() {
        return this.getToolchainManager(this.lookup, this.logger);
    }

    private DefaultToolchainManager getToolchainManager(Lookup lookup, Logger logger) {
        return this.getToolchainManager(lookup.lookupMap(ToolchainFactory.class), lookup.lookupMap(org.apache.maven.api.services.ToolchainFactory.class), logger);
    }

    private DefaultToolchainManager getToolchainManager(Map<String, ToolchainFactory> v3Factories, Map<String, org.apache.maven.api.services.ToolchainFactory> v4Factories, Logger logger) {
        HashMap<String, org.apache.maven.api.services.ToolchainFactory> allFactories = new HashMap<String, org.apache.maven.api.services.ToolchainFactory>();
        for (Map.Entry<String, ToolchainFactory> entry : v3Factories.entrySet()) {
            final ToolchainFactory v3Factory = entry.getValue();
            allFactories.put(entry.getKey(), new org.apache.maven.api.services.ToolchainFactory(){

                @Nonnull
                public org.apache.maven.api.Toolchain createToolchain(@Nonnull org.apache.maven.api.toolchain.ToolchainModel model) throws ToolchainFactoryException {
                    try {
                        return ToolchainManagerFactory.this.getToolchainV4(v3Factory.createToolchain(new ToolchainModel(model)));
                    }
                    catch (MisconfiguredToolchainException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Nonnull
                public Optional<org.apache.maven.api.Toolchain> createDefaultToolchain() throws ToolchainFactoryException {
                    return Optional.ofNullable(v3Factory.createDefaultToolchain()).map(ToolchainManagerFactory.this::getToolchainV4);
                }
            });
        }
        allFactories.putAll(v4Factories);
        return new DefaultToolchainManager(allFactories, logger){};
    }

    private org.apache.maven.api.Toolchain getToolchainV4(ToolchainPrivate toolchain) {
        ToolchainWrapperV4 toolchainWrapperV4;
        if (toolchain instanceof ToolchainWrapperV3) {
            ToolchainWrapperV3 v3tc = (ToolchainWrapperV3)toolchain;
            toolchainWrapperV4 = v3tc.delegate;
        } else {
            toolchainWrapperV4 = new ToolchainWrapperV4(toolchain);
        }
        return toolchainWrapperV4;
    }

    private ToolchainPrivate getToolchainV3(org.apache.maven.api.Toolchain toolchain) {
        ToolchainPrivate toolchainPrivate;
        if (toolchain instanceof ToolchainWrapperV4) {
            ToolchainWrapperV4 v3tc = (ToolchainWrapperV4)toolchain;
            toolchainPrivate = v3tc.delegate;
        } else {
            toolchainPrivate = new ToolchainWrapperV3(toolchain);
        }
        return toolchainPrivate;
    }

    public class DefaultToolchainManagerV3
    implements ToolchainManager,
    ToolchainManagerPrivate {
        @Override
        public Toolchain getToolchainFromBuildContext(String type, MavenSession session) {
            return ToolchainManagerFactory.this.getDelegate().getToolchainFromBuildContext(session.getSession(), type).map(ToolchainManagerFactory.this::getToolchainV3).orElse(null);
        }

        @Override
        public List<Toolchain> getToolchains(MavenSession session, String type, Map<String, String> requirements) {
            return new MappedList(ToolchainManagerFactory.this.getDelegate().getToolchains(session.getSession(), type, requirements), ToolchainManagerFactory.this::getToolchainV3);
        }

        @Override
        public ToolchainPrivate[] getToolchainsForType(String type, MavenSession session) throws MisconfiguredToolchainException {
            try {
                List toolchains = ToolchainManagerFactory.this.getDelegate().getToolchains(session.getSession(), type);
                return (ToolchainPrivate[])toolchains.stream().map(ToolchainManagerFactory.this::getToolchainV3).toArray(ToolchainPrivate[]::new);
            }
            catch (ToolchainManagerException e) {
                throw new MisconfiguredToolchainException(e.getMessage(), e);
            }
        }

        @Override
        public void storeToolchainToBuildContext(ToolchainPrivate toolchain, MavenSession session) {
            org.apache.maven.api.Toolchain tc = ToolchainManagerFactory.this.getToolchainV4(toolchain);
            ToolchainManagerFactory.this.getDelegate().storeToolchainToBuildContext(session.getSession(), tc);
        }
    }

    public class DefaultToolchainManagerV4
    implements org.apache.maven.api.services.ToolchainManager {
        @Nonnull
        public List<org.apache.maven.api.Toolchain> getToolchains(@Nonnull Session session, @Nonnull String type, @Nullable Map<String, String> requirements) throws ToolchainManagerException {
            return ToolchainManagerFactory.this.getDelegate().getToolchains(session, type, requirements);
        }

        @Nonnull
        public Optional<org.apache.maven.api.Toolchain> getToolchainFromBuildContext(@Nonnull Session session, @Nonnull String type) throws ToolchainManagerException {
            return ToolchainManagerFactory.this.getDelegate().getToolchainFromBuildContext(session, type);
        }

        public void storeToolchainToBuildContext(@Nonnull Session session, @Nonnull org.apache.maven.api.Toolchain toolchain) {
            ToolchainManagerFactory.this.getDelegate().storeToolchainToBuildContext(session, toolchain);
        }

        @Nonnull
        public List<org.apache.maven.api.Toolchain> getToolchains(@Nonnull Session session, @Nonnull String type) throws ToolchainManagerException {
            return ToolchainManagerFactory.this.getDelegate().getToolchains(session, type);
        }
    }

    private record ToolchainWrapperV3(org.apache.maven.api.Toolchain delegate) implements Toolchain,
    ToolchainPrivate
    {
        @Override
        public String getType() {
            return this.delegate.getType();
        }

        @Override
        public String findTool(String toolName) {
            return this.delegate.findTool(toolName);
        }

        @Override
        public boolean matchesRequirements(Map<String, String> requirements) {
            return this.delegate.matchesRequirements(requirements);
        }

        @Override
        public ToolchainModel getModel() {
            return new ToolchainModel(this.delegate.getModel());
        }
    }

    private record ToolchainWrapperV4(ToolchainPrivate delegate) implements org.apache.maven.api.Toolchain
    {
        public String getType() {
            return this.delegate.getType();
        }

        public String findTool(String toolName) {
            return this.delegate.findTool(toolName);
        }

        public org.apache.maven.api.toolchain.ToolchainModel getModel() {
            return this.delegate.getModel().getDelegate();
        }

        public boolean matchesRequirements(Map<String, String> requirements) {
            return this.delegate.matchesRequirements(requirements);
        }
    }
}

