/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.ssl.KeyMaterial;
import org.apache.commons.ssl.LogWrapper;
import org.apache.commons.ssl.TrustMaterial;
import org.apache.commons.ssl.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TomcatServerXML {
    private static final LogWrapper log;
    public static final KeyMaterial KEY_MATERIAL;
    public static final TrustMaterial TRUST_MATERIAL;
    public static final SortedMap KEY_MATERIAL_BY_PORT;
    public static final SortedMap TRUST_MATERIAL_BY_PORT;
    static /* synthetic */ Class class$org$apache$commons$ssl$TomcatServerXML;

    private static void loadTomcatConfig(Document d, Map keyMap, Map trustMap) {
        String userHome = System.getProperty("user.home");
        NodeList nl = d.getElementsByTagName("Connector");
        for (int i = 0; i < nl.getLength(); ++i) {
            char[] truststorePass;
            KeyMaterial km = null;
            TrustMaterial tm = null;
            Element element = (Element)nl.item(i);
            String secure = element.getAttribute("secure");
            String portString = element.getAttribute("port");
            Integer port = null;
            try {
                portString = portString != null ? portString.trim() : "";
                port = new Integer(portString);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (port == null || !Util.isYes(secure)) continue;
            String keystoreFile = element.getAttribute("keystoreFile");
            String pass = element.getAttribute("keystorePass");
            if (!element.hasAttribute("keystoreFile")) {
                keystoreFile = userHome + "/.keystore";
            }
            if (!element.hasAttribute("keystorePass")) {
                pass = "changeit";
            }
            char[] keystorePass = pass != null ? pass.toCharArray() : null;
            String truststoreFile = element.getAttribute("truststoreFile");
            pass = element.getAttribute("truststorePass");
            if (!element.hasAttribute("truststoreFile")) {
                truststoreFile = null;
            }
            if (!element.hasAttribute("truststorePass")) {
                pass = null;
            }
            char[] cArray = truststorePass = pass != null ? pass.toCharArray() : null;
            if (keystoreFile == null) {
                km = null;
            } else {
                try {
                    km = new KeyMaterial(keystoreFile, keystorePass);
                }
                catch (Exception e) {
                    log.warn("Commons-SSL failed to load [" + keystoreFile + "] " + e);
                }
            }
            if (truststoreFile == null) {
                tm = TrustMaterial.DEFAULT;
            } else {
                try {
                    tm = new TrustMaterial(truststoreFile, truststorePass);
                }
                catch (Exception e) {
                    log.warn("Commons-SSL failed to load [" + truststoreFile + "] " + e);
                }
            }
            TrustMaterial o = keyMap.put(port, km);
            if (o != null) {
                log.debug("Commons-SSL TomcatServerXML keyMap clobbered port: " + port);
            }
            if ((o = trustMap.put(port, tm)) == null) continue;
            log.debug("Commons-SSL TomcatServerXML trustMap clobbered port: " + port);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        TreeMap trustMap;
        TreeMap keyMap;
        block14: {
            log = LogWrapper.getLogger(class$org$apache$commons$ssl$TomcatServerXML == null ? (class$org$apache$commons$ssl$TomcatServerXML = TomcatServerXML.class$("org.apache.commons.ssl.TomcatServerXML")) : class$org$apache$commons$ssl$TomcatServerXML);
            String tomcatHome = System.getProperty("catalina.home");
            String serverXML = tomcatHome + "/conf/server.xml";
            keyMap = new TreeMap();
            trustMap = new TreeMap();
            InputStream in = null;
            Document doc = null;
            try {
                File f;
                if (tomcatHome != null && (f = new File(serverXML)).exists()) {
                    try {
                        in = new FileInputStream(serverXML);
                    }
                    catch (IOException ioe) {
                        log.warn("Commons-SSL failed to load Tomcat's [" + serverXML + "] " + ioe);
                    }
                }
                if (in != null) {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    try {
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        doc = db.parse(in);
                    }
                    catch (Exception e) {
                        log.warn("Commons-SSL failed to parse Tomcat's [" + serverXML + "] " + e);
                    }
                }
                if (doc != null) {
                    TomcatServerXML.loadTomcatConfig(doc, keyMap, trustMap);
                }
                Object var9_10 = null;
                if (in == null) break block14;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception e) {}
            in.close();
        }
        KEY_MATERIAL_BY_PORT = Collections.unmodifiableSortedMap(keyMap);
        TRUST_MATERIAL_BY_PORT = Collections.unmodifiableSortedMap(trustMap);
        KeyMaterial km = null;
        TrustMaterial tm = null;
        if (!keyMap.isEmpty()) {
            km = (KeyMaterial)keyMap.get(keyMap.firstKey());
        }
        if (!trustMap.isEmpty()) {
            tm = (TrustMaterial)trustMap.get(trustMap.firstKey());
        }
        KEY_MATERIAL = km;
        TRUST_MATERIAL = tm;
    }
}

