/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.parser.ParseException;

public final class ListBuilder<E> {
    private List<E> list;
    private boolean unmodifiable = false;
    private boolean sparse = false;
    private Comparator<E> comparator;
    private Class<E> elementType;
    private Type[] elementTypeArgs;

    public static <E> ListBuilder<E> create(Class<E> elementType, Type ... elementTypeArgs) {
        return new ListBuilder<E>(elementType, elementTypeArgs);
    }

    public ListBuilder(Class<E> elementType, Type ... elementTypeArgs) {
        this.elementType = elementType;
        this.elementTypeArgs = elementTypeArgs;
    }

    public ListBuilder(List<E> addTo) {
        this.list = addTo;
    }

    public List<E> build() {
        if (this.sparse) {
            if (this.list != null && this.list.isEmpty()) {
                this.list = null;
            }
        } else if (this.list == null) {
            this.list = new ArrayList(0);
        }
        if (this.list != null) {
            if (this.comparator != null) {
                Collections.sort(this.list, this.comparator);
            }
            if (this.unmodifiable) {
                this.list = Collections.unmodifiableList(this.list);
            }
        }
        return this.list;
    }

    public ListBuilder<E> sparse() {
        this.sparse = true;
        return this;
    }

    public ListBuilder<E> unmodifiable() {
        this.unmodifiable = true;
        return this;
    }

    public ListBuilder<E> copy() {
        if (this.list != null) {
            this.list = new ArrayList<E>(this.list);
        }
        return this;
    }

    public ListBuilder<E> sorted() {
        return this.sorted(Comparator.naturalOrder());
    }

    public ListBuilder<E> sorted(Comparator<E> comparator) {
        this.comparator = comparator;
        return this;
    }

    public ListBuilder<E> addAll(Collection<E> value) {
        if (value != null) {
            if (this.list == null) {
                this.list = new LinkedList<E>(value);
            } else {
                this.list.addAll(value);
            }
        }
        return this;
    }

    public ListBuilder<E> add(E value) {
        if (this.list == null) {
            this.list = new ArrayList();
        }
        this.list.add(value);
        return this;
    }

    public ListBuilder<E> add(E ... values) {
        for (E v : values) {
            this.add(v);
        }
        return this;
    }

    public ListBuilder<E> addJson(String ... values) {
        return this.addAny(values);
    }

    public ListBuilder<E> addAny(Object ... values) {
        block9: {
            if (this.elementType == null) {
                throw new IllegalStateException("Unknown element type. Cannot use this method.");
            }
            try {
                if (values == null) break block9;
                for (Object o : values) {
                    if (o == null) continue;
                    if (o instanceof Collection) {
                        ((Collection)o).forEach(x -> this.addAny(x));
                        continue;
                    }
                    if (o.getClass().isArray()) {
                        for (int i = 0; i < Array.getLength(o); ++i) {
                            this.addAny(Array.get(o, i));
                        }
                        continue;
                    }
                    if (StringUtils.isJsonArray(o, false)) {
                        new JsonList(o.toString()).forEach(x -> this.addAny(x));
                        continue;
                    }
                    if (this.elementType.isInstance(o)) {
                        this.add(this.elementType.cast(o));
                        continue;
                    }
                    this.add(ConverterUtils.toType(o, this.elementType, this.elementTypeArgs));
                }
            }
            catch (ParseException e) {
                throw ThrowableUtils.asRuntimeException(e);
            }
        }
        return this;
    }

    public ListBuilder<E> addIf(boolean flag, E value) {
        if (flag) {
            this.add(value);
        }
        return this;
    }
}

