/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Delegate;
import org.apache.juneau.common.internal.ArgUtils;

public final class FilteredMap<K, V>
extends AbstractMap<K, V>
implements Delegate<Map<K, V>> {
    final Map<K, V> innerMap;
    final Set<Map.Entry<K, V>> entries;
    final ClassMeta<Map<K, V>> classMeta;

    public FilteredMap(ClassMeta<Map<K, V>> classMeta, Map<K, V> innerMap, K[] keys) {
        ArgUtils.assertArgNotNull("innerMap", innerMap);
        ArgUtils.assertArgNotNull("keys", keys);
        this.classMeta = classMeta;
        this.innerMap = innerMap;
        ArrayList<Map.Entry<K, V>> l = new ArrayList<Map.Entry<K, V>>(keys.length);
        for (K k : keys) {
            if (!innerMap.containsKey(k)) continue;
            l.add(this.createEntry(k));
        }
        this.entries = new ListSet<Map.Entry<K, V>>(l);
    }

    private Map.Entry<K, V> createEntry(final K key) {
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return FilteredMap.this.innerMap.get(key);
            }

            @Override
            public V setValue(V v) {
                return FilteredMap.this.innerMap.put(key, v);
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entries;
    }

    @Override
    public ClassMeta<Map<K, V>> getClassMeta() {
        return this.classMeta;
    }

    private static final class ListSet<E>
    extends AbstractSet<E> {
        private List<E> entries;

        public ListSet(List<E> entries) {
            this.entries = entries;
        }

        @Override
        public Iterator<E> iterator() {
            return this.entries.iterator();
        }

        @Override
        public int size() {
            return this.entries.size();
        }
    }
}

