/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.BasicNameValuePair;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ObjectUtils;

@BeanIgnore
public class StringRange {
    private final NameValuePair[] extensions;
    private final Float qValue;
    private final String name;
    private final String string;

    public StringRange(String value) {
        this(StringRange.parse(value));
    }

    public StringRange(HeaderElement e) {
        Float qValue = Float.valueOf(1.0f);
        ArrayList<NameValuePair> extensions = CollectionUtils.list(new NameValuePair[0]);
        for (NameValuePair p : e.getParameters()) {
            if (p.getName().equals("q")) {
                qValue = Float.valueOf(Float.parseFloat(p.getValue()));
                continue;
            }
            extensions.add((NameValuePair)new BasicNameValuePair(p.getName(), p.getValue()));
        }
        this.qValue = qValue;
        this.extensions = extensions.toArray(new NameValuePair[extensions.size()]);
        this.name = e.getName();
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        if (Float.compare(qValue.floatValue(), 1.0f) == 0) {
            if (this.extensions.length > 0) {
                sb.append(";q=").append(qValue);
                extensions.forEach(x -> sb.append(';').append(x.getName()).append('=').append(x.getValue()));
            }
        } else {
            sb.append(";q=").append(qValue);
            extensions.forEach(x -> sb.append(';').append(x.getName()).append('=').append(x.getValue()));
        }
        this.string = sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public Float getQValue() {
        return this.qValue;
    }

    public List<NameValuePair> getExtensions() {
        return CollectionUtils.ulist(this.extensions);
    }

    public StringRange forEachExtension(Consumer<NameValuePair> action) {
        for (NameValuePair p : this.extensions) {
            action.accept(p);
        }
        return this;
    }

    public boolean equals(Object o) {
        return o instanceof StringRange && ObjectUtils.eq(this, (StringRange)o, (x, y) -> StringUtils.eq((String)x.string, (String)y.string));
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public int match(String name) {
        if (this.qValue.floatValue() == 0.0f) {
            return 0;
        }
        if (StringUtils.eq((String)this.name, (String)name)) {
            return 100;
        }
        if (StringUtils.eq((String)this.name, (String)"*")) {
            return 50;
        }
        return 0;
    }

    private static HeaderElement parse(String value) {
        HeaderElement[] elements = BasicHeaderValueParser.parseElements((String)StringUtils.emptyIfNull((String)StringUtils.trim((String)value)), null);
        return elements.length > 0 ? elements[0] : new BasicHeaderElement("*", "");
    }

    public String toString() {
        return this.string;
    }
}

