/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.juneau.ExecutableException;

public interface Setter {
    public void set(Object var1, Object var2) throws ExecutableException;

    public static class MethodSetter
    implements Setter {
        private final Method m;

        public MethodSetter(Method m) {
            this.m = m;
        }

        @Override
        public void set(Object object, Object value) throws ExecutableException {
            try {
                this.m.invoke(object, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new ExecutableException(e);
            }
        }
    }

    public static class FieldSetter
    implements Setter {
        private final Field f;

        public FieldSetter(Field f) {
            this.f = f;
        }

        @Override
        public void set(Object object, Object value) throws ExecutableException {
            try {
                this.f.set(object, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new ExecutableException(e);
            }
        }
    }
}

