/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.juneau.assertions.FluentByteArrayAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.http.header.ContentEncoding;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ReaderInputStream;

public class BasicHttpEntity
extends org.apache.http.entity.BasicHttpEntity {
    private Object content;
    private boolean cache;

    public static BasicHttpEntity of(Object content) {
        return new BasicHttpEntity(content);
    }

    public static BasicHttpEntity of(Supplier<?> content) {
        return new BasicHttpEntity(content);
    }

    public BasicHttpEntity(Object content) {
        this(content, null, null);
    }

    public BasicHttpEntity(Object content, ContentType contentType, ContentEncoding contentEncoding) {
        this.content = content;
        this.contentType(contentType);
        this.contentEncoding(contentEncoding);
    }

    @FluentSetter
    public BasicHttpEntity contentType(String value) {
        super.setContentType(value);
        return this;
    }

    @FluentSetter
    public BasicHttpEntity contentType(Header value) {
        super.setContentType(value);
        return this;
    }

    @FluentSetter
    public BasicHttpEntity contentLength(long value) {
        super.setContentLength(value);
        return this;
    }

    @FluentSetter
    public BasicHttpEntity contentEncoding(String value) {
        super.setContentEncoding(value);
        return this;
    }

    @FluentSetter
    public BasicHttpEntity contentEncoding(Header value) {
        super.setContentEncoding(value);
        return this;
    }

    @FluentSetter
    public BasicHttpEntity chunked() {
        return this.chunked(true);
    }

    @FluentSetter
    public BasicHttpEntity chunked(boolean value) {
        super.setChunked(value);
        return this;
    }

    @FluentSetter
    public BasicHttpEntity cache() {
        return this.cache(true);
    }

    @FluentSetter
    public BasicHttpEntity cache(boolean value) {
        this.cache = value;
        return this;
    }

    public String asString() throws IOException {
        return IOUtils.read(this.getContent());
    }

    public byte[] asBytes() throws IOException {
        try (InputStream o = this.getContent();){
            byte[] byArray = o == null ? null : IOUtils.readBytes(o);
            return byArray;
        }
    }

    public FluentStringAssertion<BasicHttpEntity> assertString() throws IOException {
        return new FluentStringAssertion<BasicHttpEntity>(this.asString(), this);
    }

    public FluentByteArrayAssertion<BasicHttpEntity> assertBytes() throws IOException {
        return new FluentByteArrayAssertion<BasicHttpEntity>(this.asBytes(), this);
    }

    public boolean isRepeatable() {
        Object o = this.getRawContent();
        return this.cache || o instanceof File || o instanceof CharSequence || o instanceof byte[];
    }

    public long getContentLength() {
        long x = super.getContentLength();
        if (x != -1L) {
            return x;
        }
        try {
            this.tryCache();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Object o = this.getRawContent();
        if (o instanceof byte[]) {
            return ((byte[])o).length;
        }
        if (o instanceof File) {
            return ((File)o).length();
        }
        if (o instanceof CharSequence) {
            return ((CharSequence)o).length();
        }
        return -1L;
    }

    public InputStream getContent() {
        try {
            this.tryCache();
            Object o = this.getRawContent();
            if (o == null) {
                return null;
            }
            if (o instanceof File) {
                return new FileInputStream((File)o);
            }
            if (o instanceof byte[]) {
                return new ByteArrayInputStream((byte[])o);
            }
            if (o instanceof Reader) {
                return new ReaderInputStream((Reader)o, IOUtils.UTF8);
            }
            if (o instanceof InputStream) {
                return (InputStream)o;
            }
            return new ReaderInputStream((Reader)new StringReader(o.toString()), IOUtils.UTF8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        this.tryCache();
        Object o = this.getRawContent();
        if (o != null) {
            IOUtils.pipe(o, os);
        }
        os.flush();
    }

    public boolean isStreaming() {
        Object o = this.getRawContent();
        return o instanceof InputStream || o instanceof Reader;
    }

    protected Object getRawContent() {
        return this.unwrap(this.content);
    }

    private void tryCache() throws IOException {
        Object o = this.getRawContent();
        if (this.cache && this.isCacheable(o)) {
            this.content = this.readBytes(o);
        }
    }

    protected boolean isCacheable(Object o) {
        return o instanceof File || o instanceof InputStream || o instanceof Reader;
    }

    protected byte[] readBytes(Object o) throws IOException {
        return IOUtils.readBytes(o);
    }

    protected Object unwrap(Object o) {
        while (o instanceof Supplier) {
            o = ((Supplier)o).get();
        }
        return o;
    }
}

