/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.BasicIllegalArgumentException;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.ResourceResolver;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.AList;
import org.apache.juneau.collections.AMap;
import org.apache.juneau.collections.ASet;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.config.Config;
import org.apache.juneau.cp.BasicResourceFinder;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.cp.ResourceFinder;
import org.apache.juneau.cp.ResourceManager;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.annotation.Body;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.HasFormData;
import org.apache.juneau.http.annotation.HasQuery;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Request;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.http.annotation.ResponseStatus;
import org.apache.juneau.http.exception.BadRequest;
import org.apache.juneau.http.exception.HttpException;
import org.apache.juneau.http.exception.InternalServerError;
import org.apache.juneau.http.exception.MethodNotAllowed;
import org.apache.juneau.http.exception.NotFound;
import org.apache.juneau.http.exception.NotImplemented;
import org.apache.juneau.http.exception.PreconditionFailed;
import org.apache.juneau.http.exception.Unauthorized;
import org.apache.juneau.http.remote.RrpcInterfaceMeta;
import org.apache.juneau.http.remote.RrpcInterfaceMethodMeta;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.msgpack.MsgPackParser;
import org.apache.juneau.mstat.MethodExecStats;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.BasicRestCallLogger;
import org.apache.juneau.rest.BasicRestInfoProvider;
import org.apache.juneau.rest.BasicRestResourceResolver;
import org.apache.juneau.rest.Enablement;
import org.apache.juneau.rest.HttpRuntimeException;
import org.apache.juneau.rest.NoOpRestLogger;
import org.apache.juneau.rest.OverrideableHttpServletRequest;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestCall;
import org.apache.juneau.rest.RestCallLogger;
import org.apache.juneau.rest.RestCallLoggerConfig;
import org.apache.juneau.rest.RestChild;
import org.apache.juneau.rest.RestContextBuilder;
import org.apache.juneau.rest.RestContextProperties;
import org.apache.juneau.rest.RestContextStats;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestInfoProvider;
import org.apache.juneau.rest.RestLogger;
import org.apache.juneau.rest.RestMethodContext;
import org.apache.juneau.rest.RestMethodContextBuilder;
import org.apache.juneau.rest.RestMethodParam;
import org.apache.juneau.rest.RestParamDefaults;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResourceResolver;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.StaticFile;
import org.apache.juneau.rest.StaticFileMapping;
import org.apache.juneau.rest.StaticFiles;
import org.apache.juneau.rest.annotation.Attr;
import org.apache.juneau.rest.annotation.HookEvent;
import org.apache.juneau.rest.annotation.Method;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestHook;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestMethodAnnotation;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.util.UrlPathInfo;
import org.apache.juneau.rest.util.UrlPathPattern;
import org.apache.juneau.rest.util.UrlPathPatternMatch;
import org.apache.juneau.rest.vars.FileVar;
import org.apache.juneau.rest.vars.LocalizationVar;
import org.apache.juneau.rest.vars.RequestAttributeVar;
import org.apache.juneau.rest.vars.RequestFormDataVar;
import org.apache.juneau.rest.vars.RequestHeaderVar;
import org.apache.juneau.rest.vars.RequestPathVar;
import org.apache.juneau.rest.vars.RequestQueryVar;
import org.apache.juneau.rest.vars.RequestVar;
import org.apache.juneau.rest.vars.RestInfoVar;
import org.apache.juneau.rest.vars.SerializedRequestAttrVar;
import org.apache.juneau.rest.vars.ServletInitParamVar;
import org.apache.juneau.rest.vars.SwaggerVar;
import org.apache.juneau.rest.vars.UrlEncodeVar;
import org.apache.juneau.rest.vars.UrlVar;
import org.apache.juneau.rest.vars.WidgetVar;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.utils.ExtendedMimetypesFileTypeMap;
import org.apache.juneau.utils.MethodInvoker;
import org.apache.juneau.utils.ReflectionMap;
import org.apache.juneau.utils.StackTraceDatabase;
import org.apache.juneau.utils.Tuple2;
import org.apache.juneau.xml.XmlParser;

@ConfigurableContext(nocache=true)
public class RestContext
extends BeanContext {
    static final String PREFIX = "RestContext";
    public static final String REST_allowBodyParam = "RestContext.allowBodyParam.b";
    public static final String REST_allowedHeaderParams = "RestContext.allowedHeaderParams.s";
    public static final String REST_allowedMethodHeaders = "RestContext.allowedMethodHeaders.s";
    public static final String REST_allowedMethodParams = "RestContext.allowedMethodParams.s";
    @Deprecated
    public static final String REST_allowHeaderParams = "RestContext.allowHeaderParams.b";
    @Deprecated
    public static final String REST_callHandler = "RestContext.callHandler.o";
    public static final String REST_callLogger = "RestContext.callLogger.o";
    public static final String REST_callLoggerConfig = "RestContext.callLoggerConfig.o";
    public static final String REST_children = "RestContext.children.lo";
    public static final String REST_classpathResourceFinder = "RestContext.classpathResourceFinder.o";
    public static final String REST_clientVersionHeader = "RestContext.clientVersionHeader.s";
    public static final String REST_converters = "RestContext.converters.lo";
    public static final String REST_debug = "RestContext.debug.s";
    public static final String REST_debugOn = "RestContext.debugOn.s";
    public static final String REST_defaultCharset = "RestContext.defaultCharset.s";
    @Deprecated
    public static final String REST_attrs = "RestContext.reqAttrs.smo";
    @Deprecated
    public static final String REST_defaultRequestHeaders = "RestContext.reqHeaders.smo";
    @Deprecated
    public static final String REST_defaultResponseHeaders = "RestContext.resHeaders.omo";
    public static final String REST_encoders = "RestContext.encoders.lo";
    public static final String REST_guards = "RestContext.guards.lo";
    public static final String REST_infoProvider = "RestContext.infoProvider.o";
    @Deprecated
    public static final String REST_logger = "RestContext.logger.o";
    public static final String REST_maxInput = "RestContext.maxInput.s";
    public static final String REST_messages = "RestContext.messages.lo";
    public static final String REST_mimeTypes = "RestContext.mimeTypes.ss";
    public static final String REST_paramResolvers = "RestContext.paramResolvers.lo";
    public static final String REST_parsers = "RestContext.parsers.lo";
    public static final String REST_partParser = "RestContext.partParser.o";
    public static final String REST_partSerializer = "RestContext.partSerializer.o";
    public static final String REST_path = "RestContext.path.s";
    public static final String REST_renderResponseStackTraces = "RestContext.renderResponseStackTraces.b";
    public static final String REST_reqAttrs = "RestContext.reqAttrs.smo";
    public static final String REST_reqHeaders = "RestContext.reqHeaders.smo";
    public static final String REST_resHeaders = "RestContext.resHeaders.omo";
    public static final String REST_resourceResolver = "RestContext.resourceResolver.o";
    public static final String REST_responseHandlers = "RestContext.responseHandlers.lo";
    public static final String REST_rolesDeclared = "RestContext.rolesDeclared.ss";
    public static final String REST_roleGuard = "RestContext.roleGuard.ss";
    public static final String REST_serializers = "RestContext.serializers.lo";
    public static final String REST_staticFileResponseHeaders = "RestContext.staticFileResponseHeaders.omo";
    public static final String REST_staticFiles = "RestContext.staticFiles.lo";
    public static final String REST_produces = "RestContext.produces.ls";
    public static final String REST_properties = "RestContext.properties.sms";
    public static final String REST_consumes = "RestContext.consumes.ls";
    public static final String REST_context = "RestContext.context.c";
    public static final String REST_useClasspathResourceCaching = "RestContext.useClasspathResourceCaching.b";
    @Deprecated
    public static final String REST_useStackTraceHashes = "RestContext.useStackTraceHashes.b";
    public static final String REST_uriAuthority = "RestContext.uriAuthority.s";
    public static final String REST_uriContext = "RestContext.uriContext.s";
    public static final String REST_uriRelativity = "RestContext.uriRelativity.s";
    public static final String REST_uriResolution = "RestContext.uriResolution.s";
    @Deprecated
    public static final String REST_widgets = "RestContext.widgets.lo";
    private static final Map<Class<?>, RestContext> REGISTRY = new ConcurrentHashMap();
    private final Object resource;
    final RestContextBuilder builder;
    private final boolean allowBodyParam;
    private final boolean renderResponseStackTraces;
    private final boolean useClasspathResourceCaching;
    private final Enablement debug;
    @Deprecated
    private final boolean useStackTraceHashes;
    private final String clientVersionHeader;
    private final String uriAuthority;
    private final String uriContext;
    final String fullPath;
    final UrlPathPattern pathPattern;
    private final Set<String> allowedMethodParams;
    private final Set<String> allowedHeaderParams;
    private final Set<String> allowedMethodHeaders;
    private final RestContextProperties properties;
    private final Map<Class<?>, RestMethodParam> paramResolvers;
    private final SerializerGroup serializers;
    private final ParserGroup parsers;
    private final HttpPartSerializer partSerializer;
    private final HttpPartParser partParser;
    private final JsonSchemaGenerator jsonSchemaGenerator;
    private final List<MediaType> consumes;
    private final List<MediaType> produces;
    private final Map<String, Object> reqHeaders;
    private final Map<String, Object> resHeaders;
    private final Map<String, Object> staticFileResponseHeaders;
    private final OMap reqAttrs;
    private final ResponseHandler[] responseHandlers;
    private final MimetypesFileTypeMap mimetypesFileTypeMap;
    private final StaticFiles[] staticFiles;
    private final String[] staticFilesPaths;
    private final Messages msgs;
    private final Config config;
    private final VarResolver varResolver;
    private final Map<String, List<RestMethodContext>> methodMap;
    private final List<RestMethodContext> methods;
    private final Map<String, RestContext> childResources;
    private final RestLogger logger;
    private final RestCallLogger callLogger;
    private final RestCallLoggerConfig callLoggerConfig;
    private final StackTraceDatabase stackTraceDb;
    private final RestInfoProvider infoProvider;
    private final HttpException initException;
    private final RestContext parentContext;
    private final RestResourceResolver resourceResolver;
    private final UriResolution uriResolution;
    private final UriRelativity uriRelativity;
    private final ConcurrentHashMap<String, MethodExecStats> methodExecStats = new ConcurrentHashMap();
    private final Instant startTime;
    private final Map<Class<?>, ResponseBeanMeta> responseBeanMetas = new ConcurrentHashMap();
    private final MethodInvoker[] postInitMethods;
    private final MethodInvoker[] postInitChildFirstMethods;
    private final MethodInvoker[] preCallMethods;
    private final MethodInvoker[] postCallMethods;
    private final MethodInvoker[] startCallMethods;
    private final MethodInvoker[] endCallMethods;
    private final MethodInvoker[] destroyMethods;
    private final RestMethodParam[][] preCallMethodParams;
    private final RestMethodParam[][] postCallMethodParams;
    private final Class<?>[][] postInitMethodParams;
    private final Class<?>[][] postInitChildFirstMethodParams;
    private final Class<?>[][] startCallMethodParams;
    private final Class<?>[][] endCallMethodParams;
    private final Class<?>[][] destroyMethodParams;
    private final Map<String, StaticFile> staticFilesCache = new ConcurrentHashMap<String, StaticFile>();
    private final ResourceManager staticResourceManager;
    @Deprecated
    private final ConcurrentHashMap<Integer, AtomicInteger> stackTraceHashes = new ConcurrentHashMap();
    private final ThreadLocal<RestCall> call = new ThreadLocal();
    private final ReflectionMap<Enablement> debugEnablement;

    public static final Map<Class<?>, RestContext> getGlobalRegistry() {
        return Collections.unmodifiableMap(REGISTRY);
    }

    public static RestContextBuilder create(Object resource) throws ServletException {
        return new RestContextBuilder(null, resource.getClass(), null).init(resource);
    }

    static RestContextBuilder create(ServletConfig servletConfig, Class<?> resourceClass, RestContext parentContext) throws ServletException {
        return new RestContextBuilder(servletConfig, resourceClass, parentContext);
    }

    public RestContext(RestContextBuilder builder) throws Exception {
        super(builder.getPropertyStore());
        this.startTime = Instant.now();
        REGISTRY.put(builder.resourceClass, this);
        HttpException _initException = null;
        try {
            ServletContext servletContext = builder.servletContext;
            this.resource = builder.resource;
            this.builder = builder;
            this.parentContext = builder.parentContext;
            RestResourceResolver defaultResourceResolver = this.parentContext == null ? (this.resource instanceof RestResourceResolver ? this.resource : BasicRestResourceResolver.class) : this.parentContext.resourceResolver;
            this.resourceResolver = this.getInstanceProperty(REST_resourceResolver, this.resource, RestResourceResolver.class, (Object)defaultResourceResolver, ResourceResolver.FUZZY, this);
            this.varResolver = builder.varResolverBuilder.vars(FileVar.class, LocalizationVar.class, RequestAttributeVar.class, RequestFormDataVar.class, RequestHeaderVar.class, RequestPathVar.class, RequestQueryVar.class, RequestVar.class, RestInfoVar.class, SerializedRequestAttrVar.class, ServletInitParamVar.class, SwaggerVar.class, UrlVar.class, UrlEncodeVar.class, WidgetVar.class).build();
            VarResolverSession vrs = this.varResolver.createSession();
            this.config = builder.config.resolving(vrs);
            ClassInfo rci = ClassInfo.of(this.resource).resolved();
            PropertyStore ps = this.getPropertyStore();
            this.uriContext = StringUtils.nullIfEmpty(this.getStringProperty(REST_uriContext, null));
            this.uriAuthority = StringUtils.nullIfEmpty(this.getStringProperty(REST_uriAuthority, null));
            this.uriResolution = this.getProperty(REST_uriResolution, UriResolution.class, UriResolution.ROOT_RELATIVE);
            this.uriRelativity = this.getProperty(REST_uriRelativity, UriRelativity.class, UriRelativity.RESOURCE);
            this.allowBodyParam = this.getBooleanProperty(REST_allowBodyParam, true);
            this.allowedHeaderParams = CollectionUtils.newUnmodifiableSortedCaseInsensitiveSet(this.getStringPropertyWithNone(REST_allowedHeaderParams, "Accept,Content-Type"));
            this.allowedMethodParams = CollectionUtils.newUnmodifiableSortedCaseInsensitiveSet(this.getStringPropertyWithNone(REST_allowedMethodParams, "HEAD,OPTIONS"));
            this.allowedMethodHeaders = CollectionUtils.newUnmodifiableSortedCaseInsensitiveSet(this.getStringPropertyWithNone(REST_allowedMethodHeaders, ""));
            this.renderResponseStackTraces = this.getBooleanProperty(REST_renderResponseStackTraces, false);
            this.useStackTraceHashes = this.getBooleanProperty(REST_useStackTraceHashes, true);
            this.clientVersionHeader = this.getStringProperty(REST_clientVersionHeader, "X-Client-Version");
            ReflectionMap.Builder<Enablement> deb = ReflectionMap.create(Enablement.class);
            for (String string : StringUtils.split(this.getStringProperty(REST_debugOn, ""))) {
                String string2 = string.trim();
                if (string2.isEmpty()) continue;
                int i = string2.indexOf(61);
                if (i == -1) {
                    deb.append(string2.trim(), Enablement.TRUE);
                    continue;
                }
                deb.append(string2.substring(0, i).trim(), Enablement.fromString(string2.substring(i + 1).trim()));
            }
            boolean debug = this.isDebug();
            Enablement de = this.getInstanceProperty(REST_debug, Enablement.class, (Object)(debug ? Enablement.TRUE : Enablement.FALSE));
            if (de != null) {
                deb.append(rci.getFullName(), de);
            }
            for (MethodInfo methodInfo : rci.getPublicMethods()) {
                for (RestMethod a : methodInfo.getAnnotations(RestMethod.class)) {
                    if (a == null || a.debug().isEmpty()) continue;
                    deb.append(methodInfo.getFullName(), Enablement.fromString(a.debug()));
                }
            }
            this.debugEnablement = deb.build();
            this.debug = this.debugEnablement.find(rci.inner(), Enablement.class).orElse(Enablement.FALSE);
            this.responseHandlers = this.getInstanceArrayProperty(REST_responseHandlers, this.resource, ResponseHandler.class, new ResponseHandler[0], this.resourceResolver, this);
            AMap<Class<?>, RestMethodParam> _paramResolvers = AMap.of();
            for (RestMethodParam restMethodParam : this.getInstanceArrayProperty(REST_paramResolvers, RestMethodParam.class, new RestMethodParam[0], this.resourceResolver, this)) {
                _paramResolvers.put(restMethodParam.forClass(), restMethodParam);
            }
            this.paramResolvers = _paramResolvers.unmodifiable();
            TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            treeMap.putAll(this.getMapProperty("RestContext.reqHeaders.smo", String.class));
            this.reqHeaders = AMap.unmodifiable(treeMap);
            this.reqAttrs = new OMap(this.getMapProperty("RestContext.reqAttrs.smo", Object.class)).unmodifiable();
            this.resHeaders = this.getMapProperty("RestContext.resHeaders.omo", Object.class);
            this.staticFileResponseHeaders = this.getMapProperty(REST_staticFileResponseHeaders, Object.class);
            this.logger = this.getInstanceProperty(REST_logger, this.resource, RestLogger.class, NoOpRestLogger.class, this.resourceResolver, this);
            Object clc = this.getProperty(REST_callLoggerConfig);
            this.callLoggerConfig = this.debug == Enablement.TRUE ? RestCallLoggerConfig.DEFAULT_DEBUG : (clc instanceof RestCallLoggerConfig ? (RestCallLoggerConfig)clc : (clc instanceof OMap ? RestCallLoggerConfig.create().apply((OMap)clc).build() : RestCallLoggerConfig.DEFAULT_NOOP));
            this.stackTraceDb = new StackTraceDatabase(this.callLoggerConfig.getStackTraceHashingTimeout(), RestMethodContext.class);
            Object defaultRestCallLogger = this.resource instanceof RestCallLogger ? this.resource : BasicRestCallLogger.class;
            this.callLogger = this.getInstanceProperty(REST_callLogger, this.resource, RestCallLogger.class, defaultRestCallLogger, this.resourceResolver, this);
            this.properties = builder.properties;
            this.serializers = SerializerGroup.create().append(this.getInstanceArrayProperty(REST_serializers, Serializer.class, new Serializer[0], this.resourceResolver, this.resource, ps)).build();
            this.parsers = ParserGroup.create().append(this.getInstanceArrayProperty(REST_parsers, Parser.class, new Parser[0], this.resourceResolver, this.resource, ps)).build();
            this.partSerializer = this.getInstanceProperty(REST_partSerializer, HttpPartSerializer.class, OpenApiSerializer.class, this.resourceResolver, this.resource, ps);
            this.partParser = this.getInstanceProperty(REST_partParser, HttpPartParser.class, OpenApiParser.class, this.resourceResolver, this.resource, ps);
            this.jsonSchemaGenerator = JsonSchemaGenerator.create().apply(ps).build();
            this.mimetypesFileTypeMap = new ExtendedMimetypesFileTypeMap();
            for (String mimeType : this.getArrayProperty(REST_mimeTypes, String.class)) {
                this.mimetypesFileTypeMap.addMimeTypes(mimeType);
            }
            Object object = this.resource instanceof ResourceFinder ? this.resource : BasicResourceFinder.class;
            ResourceFinder rf = this.getInstanceProperty(REST_classpathResourceFinder, ResourceFinder.class, object, this.resourceResolver, this);
            this.useClasspathResourceCaching = this.getProperty(REST_useClasspathResourceCaching, Boolean.TYPE, true);
            this.staticResourceManager = new ResourceManager(rci.inner(), rf, this.useClasspathResourceCaching);
            this.consumes = this.getListProperty(REST_consumes, MediaType.class, this.parsers.getSupportedMediaTypes());
            this.produces = this.getListProperty(REST_produces, MediaType.class, this.serializers.getSupportedMediaTypes());
            StaticFileMapping[] staticFileMappings = this.getArrayProperty(REST_staticFiles, StaticFileMapping.class, new StaticFileMapping[0]);
            this.staticFiles = new StaticFiles[staticFileMappings.length];
            for (int i = 0; i < this.staticFiles.length; ++i) {
                this.staticFiles[i] = new StaticFiles(staticFileMappings[i], this.staticResourceManager, this.mimetypesFileTypeMap, this.staticFileResponseHeaders);
            }
            TreeSet<String> s = new TreeSet<String>();
            for (StaticFiles sf : this.staticFiles) {
                s.add(sf.getPath());
            }
            this.staticFilesPaths = s.toArray(new String[s.size()]);
            Tuple2[] mbl = this.getInstanceArrayProperty(REST_messages, Tuple2.class, new Tuple2[0]);
            Messages msgs = null;
            for (int i = mbl.length - 1; i >= 0; --i) {
                msgs = Messages.create(ObjectUtils.firstNonNull((Class)mbl[i].getA(), rci.inner())).name((String)mbl[i].getB()).parent(msgs).build();
            }
            this.msgs = msgs;
            this.fullPath = (builder.parentContext == null ? "" : builder.parentContext.fullPath + '/') + builder.getPath();
            String p = builder.getPath();
            if (!p.endsWith("/*")) {
                p = p + "/*";
            }
            this.pathPattern = new UrlPathPattern(p);
            this.childResources = Collections.synchronizedMap(new LinkedHashMap());
            LinkedList<String> methodsFound = new LinkedList<String>();
            MethodMapBuilder methodMapBuilder = new MethodMapBuilder();
            AMap<String, java.lang.reflect.Method> _startCallMethods = AMap.of();
            AMap<String, java.lang.reflect.Method> _preCallMethods = AMap.of();
            AMap<String, java.lang.reflect.Method> _postCallMethods = AMap.of();
            AMap<String, java.lang.reflect.Method> _endCallMethods = AMap.of();
            AMap<String, java.lang.reflect.Method> _postInitMethods = AMap.of();
            AMap<String, java.lang.reflect.Method> _postInitChildFirstMethods = AMap.of();
            AMap<String, java.lang.reflect.Method> _destroyMethods = AMap.of();
            AList _preCallMethodParams = AList.of();
            AList _postCallMethodParams = AList.of();
            AList _startCallMethodParams = AList.of();
            AList _endCallMethodParams = AList.of();
            AList _postInitMethodParams = AList.of();
            AList _postInitChildFirstMethodParams = AList.of();
            AList _destroyMethodParams = AList.of();
            for (MethodInfo mi : rci.getPublicMethods()) {
                RestMethod a = mi.getLastAnnotation(RestMethod.class);
                if (a == null) {
                    for (java.lang.reflect.Method mi2 : mi.getMatching()) {
                        Class<?> ci2 = mi2.getDeclaringClass();
                        if (!ci2.isInterface() || ci2.getAnnotation(Rest.class) == null) continue;
                        a = new RestMethodAnnotation();
                    }
                }
                if (a == null) continue;
                methodsFound.add(mi.getSimpleName() + "," + StringUtils.emptyIfNull(StringUtils.firstNonEmpty(a.name(), a.method())) + "," + RestUtils.fixMethodPath(a.path()));
                try {
                    if (mi.isNotPublic()) {
                        throw new RestServletException("@RestMethod method {0}.{1} must be defined as public.", rci.inner().getName(), mi.getSimpleName());
                    }
                    RestMethodContextBuilder rmcb = new RestMethodContextBuilder(this.resource, mi.inner(), this);
                    RestMethodContext sm = new RestMethodContext(rmcb);
                    String httpMethod = sm.getHttpMethod();
                    if ("RRPC".equals(httpMethod)) {
                        ClassMeta interfaceClass = this.getClassMeta(mi.inner().getGenericReturnType(), new Type[0]);
                        final RrpcInterfaceMeta rim = new RrpcInterfaceMeta(interfaceClass.getInnerClass(), null);
                        if (rim.getMethodsByPath().isEmpty()) {
                            throw new RestException(500, "Method {0} returns an interface {1} that doesn't define any remote methods.", mi.getSignature(), interfaceClass.getFullName());
                        }
                        RestMethodContextBuilder smb = new RestMethodContextBuilder(this.resource, mi.inner(), this);
                        smb.dotAll();
                        sm = new RestMethodContext(smb){

                            @Override
                            void invoke(RestCall call) throws Throwable {
                                super.invoke(call);
                                Object o = call.getOutput();
                                if ("GET".equals(call.getMethod())) {
                                    call.output(rim.getMethodsByPath().keySet());
                                    return;
                                }
                                if ("POST".equals(call.getMethod())) {
                                    RrpcInterfaceMethodMeta rmm;
                                    String pip = call.getUrlPathInfo().getPath();
                                    if (pip.indexOf(47) != -1) {
                                        pip = pip.substring(pip.lastIndexOf(47) + 1);
                                    }
                                    if ((rmm = rim.getMethodMetaByPath(pip = StringUtils.urlDecode(pip))) != null) {
                                        java.lang.reflect.Method m = rmm.getJavaMethod();
                                        try {
                                            RestRequest req = call.getRestRequest();
                                            Parser p = req.getBody().getParser();
                                            Object[] args = null;
                                            if (m.getGenericParameterTypes().length == 0) {
                                                args = new Object[]{};
                                            } else {
                                                try (BufferedReader in = p.isReaderParser() ? req.getReader() : req.getInputStream();){
                                                    args = p.parseArgs(in, m.getGenericParameterTypes());
                                                }
                                            }
                                            Object output = m.invoke(o, args);
                                            call.output(output);
                                            return;
                                        }
                                        catch (Exception e) {
                                            throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
                                        }
                                    }
                                }
                                throw new NotFound();
                            }
                        };
                        methodMapBuilder.add("GET", sm).add("POST", sm);
                        continue;
                    }
                    methodMapBuilder.add(httpMethod, sm);
                }
                catch (Throwable e) {
                    throw new RestServletException(e, "Problem occurred trying to initialize methods on class {0}, methods={1}", rci.inner().getName(), SimpleJsonSerializer.DEFAULT.serialize(methodsFound));
                }
            }
            for (MethodInfo m : rci.getAllMethodsParentFirst()) {
                if (!m.isPublic() || !m.hasAnnotation(RestHook.class)) continue;
                HookEvent he = m.getLastAnnotation(RestHook.class).value();
                String sig = m.getSignature();
                switch (he) {
                    case PRE_CALL: {
                        if (_preCallMethods.containsKey(sig)) break;
                        m.setAccessible();
                        _preCallMethods.put(sig, m.inner());
                        _preCallMethodParams.add(this.findParams(m, true, null));
                        break;
                    }
                    case POST_CALL: {
                        if (_postCallMethods.containsKey(sig)) break;
                        m.setAccessible();
                        _postCallMethods.put(sig, m.inner());
                        _postCallMethodParams.add(this.findParams(m, true, null));
                        break;
                    }
                    case START_CALL: {
                        if (_startCallMethods.containsKey(sig)) break;
                        m.setAccessible();
                        _startCallMethods.put(sig, m.inner());
                        _startCallMethodParams.add((Class[])m.getRawParamTypes().toArray());
                        BasicIllegalArgumentException.assertArgsOnlyOfType(m, HttpServletRequest.class, HttpServletResponse.class);
                        break;
                    }
                    case END_CALL: {
                        if (_endCallMethods.containsKey(sig)) break;
                        m.setAccessible();
                        _endCallMethods.put(sig, m.inner());
                        _endCallMethodParams.add((Class[])m.getRawParamTypes().toArray());
                        BasicIllegalArgumentException.assertArgsOnlyOfType(m, HttpServletRequest.class, HttpServletResponse.class);
                        break;
                    }
                    case POST_INIT: {
                        if (_postInitMethods.containsKey(sig)) break;
                        m.setAccessible();
                        _postInitMethods.put(sig, m.inner());
                        _postInitMethodParams.add((Class[])m.getRawParamTypes().toArray());
                        BasicIllegalArgumentException.assertArgsOnlyOfType(m, RestContext.class);
                        break;
                    }
                    case POST_INIT_CHILD_FIRST: {
                        if (_postInitChildFirstMethods.containsKey(sig)) break;
                        m.setAccessible();
                        _postInitChildFirstMethods.put(sig, m.inner());
                        _postInitChildFirstMethodParams.add((Class[])m.getRawParamTypes().toArray());
                        BasicIllegalArgumentException.assertArgsOnlyOfType(m, RestContext.class);
                        break;
                    }
                    case DESTROY: {
                        if (_destroyMethods.containsKey(sig)) break;
                        m.setAccessible();
                        _destroyMethods.put(sig, m.inner());
                        _destroyMethodParams.add((Class[])m.getRawParamTypes().toArray());
                        BasicIllegalArgumentException.assertArgsOnlyOfType(m, RestContext.class);
                        break;
                    }
                }
            }
            this.preCallMethods = _preCallMethods.values().stream().map(x -> new MethodInvoker((java.lang.reflect.Method)x, this.getMethodExecStats((java.lang.reflect.Method)x))).collect(Collectors.toList()).toArray(new MethodInvoker[_preCallMethods.size()]);
            this.postCallMethods = _postCallMethods.values().stream().map(x -> new MethodInvoker((java.lang.reflect.Method)x, this.getMethodExecStats((java.lang.reflect.Method)x))).collect(Collectors.toList()).toArray(new MethodInvoker[_postCallMethods.size()]);
            this.startCallMethods = _startCallMethods.values().stream().map(x -> new MethodInvoker((java.lang.reflect.Method)x, this.getMethodExecStats((java.lang.reflect.Method)x))).collect(Collectors.toList()).toArray(new MethodInvoker[_startCallMethods.size()]);
            this.endCallMethods = _endCallMethods.values().stream().map(x -> new MethodInvoker((java.lang.reflect.Method)x, this.getMethodExecStats((java.lang.reflect.Method)x))).collect(Collectors.toList()).toArray(new MethodInvoker[_endCallMethods.size()]);
            this.postInitMethods = _postInitMethods.values().stream().map(x -> new MethodInvoker((java.lang.reflect.Method)x, this.getMethodExecStats((java.lang.reflect.Method)x))).collect(Collectors.toList()).toArray(new MethodInvoker[_postInitMethods.size()]);
            this.postInitChildFirstMethods = _postInitChildFirstMethods.values().stream().map(x -> new MethodInvoker((java.lang.reflect.Method)x, this.getMethodExecStats((java.lang.reflect.Method)x))).collect(Collectors.toList()).toArray(new MethodInvoker[_postInitChildFirstMethods.size()]);
            this.destroyMethods = _destroyMethods.values().stream().map(x -> new MethodInvoker((java.lang.reflect.Method)x, this.getMethodExecStats((java.lang.reflect.Method)x))).collect(Collectors.toList()).toArray(new MethodInvoker[_destroyMethods.size()]);
            this.preCallMethodParams = (RestMethodParam[][])_preCallMethodParams.toArray((T[])new RestMethodParam[_preCallMethodParams.size()][]);
            this.postCallMethodParams = (RestMethodParam[][])_postCallMethodParams.toArray((T[])new RestMethodParam[_postCallMethodParams.size()][]);
            this.startCallMethodParams = (Class[][])_startCallMethodParams.toArray((T[])new Class[_startCallMethodParams.size()][]);
            this.endCallMethodParams = (Class[][])_endCallMethodParams.toArray((T[])new Class[_endCallMethodParams.size()][]);
            this.postInitMethodParams = (Class[][])_postInitMethodParams.toArray((T[])new Class[_postInitMethodParams.size()][]);
            this.postInitChildFirstMethodParams = (Class[][])_postInitChildFirstMethodParams.toArray((T[])new Class[_postInitChildFirstMethodParams.size()][]);
            this.destroyMethodParams = (Class[][])_destroyMethodParams.toArray((T[])new Class[_destroyMethodParams.size()][]);
            this.methodMap = methodMapBuilder.getMap();
            this.methods = methodMapBuilder.getList();
            for (Object o : this.getArrayProperty(REST_children, Object.class)) {
                String path = null;
                Object r = null;
                if (o instanceof RestChild) {
                    RestChild rc = (RestChild)o;
                    path = rc.path;
                    r = rc.resource;
                } else if (o instanceof Class) {
                    Class c = (Class)o;
                    if (c == builder.resourceClass) continue;
                    r = c;
                } else {
                    r = o;
                }
                RestContextBuilder childBuilder = null;
                if (o instanceof Class) {
                    Class oc = (Class)o;
                    childBuilder = RestContext.create(builder.inner, oc, this);
                    r = this.resourceResolver.resolve(this.resource, oc, childBuilder, new Object[0]);
                } else {
                    r = o;
                    childBuilder = RestContext.create(builder.inner, o.getClass(), this);
                }
                childBuilder.init(r);
                if (r instanceof RestServlet) {
                    ((RestServlet)r).innerInit(childBuilder);
                }
                childBuilder.servletContext(servletContext);
                RestContext rc2 = childBuilder.build();
                if (r instanceof RestServlet) {
                    ((RestServlet)r).setContext(rc2);
                }
                path = childBuilder.getPath();
                this.childResources.put(path, rc2);
            }
            Object defaultRestInfoProvider = this.resource instanceof RestInfoProvider ? this.resource : BasicRestInfoProvider.class;
            this.infoProvider = this.getInstanceProperty(REST_infoProvider, this.resource, RestInfoProvider.class, defaultRestInfoProvider, this.resourceResolver, this);
        }
        catch (HttpException e) {
            _initException = e;
            throw e;
        }
        catch (Exception e) {
            _initException = new InternalServerError(e);
            throw e;
        }
        finally {
            this.initException = _initException;
        }
    }

    protected RestResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    protected MethodExecStats getMethodExecStats(java.lang.reflect.Method m) {
        String n = MethodInfo.of(m).getSimpleName();
        MethodExecStats ts = this.methodExecStats.get(n);
        if (ts == null) {
            this.methodExecStats.putIfAbsent(n, new MethodExecStats(m));
            ts = this.methodExecStats.get(n);
        }
        return ts;
    }

    public VarResolver getVarResolver() {
        return this.varResolver;
    }

    public Config getConfig() {
        return this.config;
    }

    protected StaticFile getStaticFile(String pathInfo) throws NotFound, IOException {
        if (!this.staticFilesCache.containsKey(pathInfo)) {
            StaticFiles sfs;
            String p = StringUtils.urlDecode(StringUtils.trimSlashes(pathInfo));
            if (p.indexOf("..") != -1) {
                throw new NotFound("Invalid path");
            }
            StaticFile sf = null;
            StaticFiles[] staticFilesArray = this.staticFiles;
            int n = staticFilesArray.length;
            for (int i = 0; i < n && (sf = (sfs = staticFilesArray[i]).resolve(p)) == null; ++i) {
            }
            if (sf == null) {
                sf = new StaticFile(null, null, null);
            }
            if (this.useClasspathResourceCaching) {
                if (this.staticFilesCache.size() > 100) {
                    this.staticFilesCache.clear();
                }
                this.staticFilesCache.put(pathInfo, sf);
            }
            return sf;
        }
        return this.staticFilesCache.get(pathInfo);
    }

    public InputStream getClasspathResource(String name, Locale locale) throws IOException {
        return this.staticResourceManager.getStream(name, locale);
    }

    public String getClasspathResourceAsString(String name, Locale locale) throws IOException {
        return this.staticResourceManager.getString(name, locale);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getClasspathResource(Class<T> c, MediaType mediaType, String name, Locale locale) throws IOException, ServletException {
        InputStream is = this.getClasspathResource(name, locale);
        if (is == null) {
            return null;
        }
        try {
            Parser p = this.parsers.getParser(mediaType);
            if (p == null) {
                if (mediaType == MediaType.JSON) {
                    p = JsonParser.DEFAULT;
                }
                if (mediaType == MediaType.XML) {
                    p = XmlParser.DEFAULT;
                }
                if (mediaType == MediaType.HTML) {
                    p = HtmlParser.DEFAULT;
                }
                if (mediaType == MediaType.UON) {
                    p = UonParser.DEFAULT;
                }
                if (mediaType == MediaType.URLENCODING) {
                    p = UrlEncodingParser.DEFAULT;
                }
                if (mediaType == MediaType.MSGPACK) {
                    p = MsgPackParser.DEFAULT;
                }
            }
            if (p == null) throw new ServletException("Unknown media type '" + mediaType + "'");
            try (Closeable in = p.isReaderParser() ? new InputStreamReader(is, IOUtils.UTF8) : is;){
                T t = p.parse((Object)in, c);
                return t;
            }
            catch (ParseException e) {
                throw new ServletException("Could not parse resource '" + name + " as media type '" + mediaType + "'.", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new ServletException("Could not parse resource with name '" + name + "'", (Throwable)e);
        }
    }

    public String getPath() {
        return this.fullPath;
    }

    @Deprecated
    public RestLogger getLogger() {
        return this.logger;
    }

    public RestCallLogger getCallLogger() {
        return this.callLogger;
    }

    public RestCallLoggerConfig getCallLoggerConfig() {
        return this.callLoggerConfig;
    }

    public Messages getMessages() {
        return this.msgs;
    }

    public RestInfoProvider getInfoProvider() {
        return this.infoProvider;
    }

    public Object getResource() {
        return this.resource;
    }

    public RestServlet getRestServlet() {
        return this.resource instanceof RestServlet ? (RestServlet)this.resource : null;
    }

    protected void checkForInitException() throws HttpException {
        if (this.initException != null) {
            throw this.initException;
        }
    }

    public RestContext getParentContext() {
        return this.parentContext;
    }

    public RestContextProperties getProperties() {
        return this.properties;
    }

    public String getServletInitParameter(String name) {
        return this.builder.getInitParameter(name);
    }

    public Map<String, RestContext> getChildResources() {
        return Collections.unmodifiableMap(this.childResources);
    }

    @Deprecated
    public int getStackTraceOccurrence(Throwable e) {
        if (!this.useStackTraceHashes) {
            return 0;
        }
        int h = e.hashCode();
        this.stackTraceHashes.putIfAbsent(h, new AtomicInteger());
        return this.stackTraceHashes.get(h).incrementAndGet();
    }

    public boolean isRenderResponseStackTraces() {
        return this.renderResponseStackTraces;
    }

    public boolean isAllowBodyParam() {
        return this.allowBodyParam;
    }

    public Set<String> getAllowedHeaderParams() {
        return this.allowedHeaderParams;
    }

    public Set<String> getAllowedMethodHeaders() {
        return this.allowedMethodHeaders;
    }

    public Set<String> getAllowedMethodParams() {
        return this.allowedMethodParams;
    }

    public Enablement getDebug(java.lang.reflect.Method method) {
        if (method == null) {
            return null;
        }
        return this.debugEnablement.find(method).orElse(this.debug);
    }

    public String getClientVersionHeader() {
        return this.clientVersionHeader;
    }

    public HttpPartParser getPartParser() {
        return this.partParser;
    }

    public HttpPartSerializer getPartSerializer() {
        return this.partSerializer;
    }

    public JsonSchemaGenerator getJsonSchemaGenerator() {
        return this.jsonSchemaGenerator;
    }

    public List<MediaType> getProduces() {
        return this.produces;
    }

    public List<MediaType> getConsumes() {
        return this.consumes;
    }

    public Map<String, Object> getReqHeaders() {
        return this.reqHeaders;
    }

    public OMap getReqAttrs() {
        return this.reqAttrs;
    }

    public Map<String, Object> getResHeaders() {
        return this.resHeaders;
    }

    protected ResponseHandler[] getResponseHandlers() {
        return this.responseHandlers;
    }

    public String getUriAuthority() {
        if (this.uriAuthority != null) {
            return this.uriAuthority;
        }
        if (this.parentContext != null) {
            return this.parentContext.getUriAuthority();
        }
        return null;
    }

    public String getUriContext() {
        if (this.uriContext != null) {
            return this.uriContext;
        }
        if (this.parentContext != null) {
            return this.parentContext.getUriContext();
        }
        return null;
    }

    public UriRelativity getUriRelativity() {
        return this.uriRelativity;
    }

    public UriResolution getUriResolution() {
        return this.uriResolution;
    }

    public String getMediaTypeForName(String name) {
        return this.mimetypesFileTypeMap.getContentType(name);
    }

    public boolean isStaticFile(String p) {
        return StringUtils.pathStartsWith(p, this.staticFilesPaths);
    }

    public List<RestMethodContext> getMethodContexts() {
        return this.methods;
    }

    public StackTraceDatabase getStackTraceDb() {
        return this.stackTraceDb;
    }

    public List<MethodExecStats> getMethodExecStats() {
        return this.methodExecStats.values().stream().sorted().collect(Collectors.toList());
    }

    public RestContextStats getStats() {
        return new RestContextStats(this.startTime, this.getMethodExecStats());
    }

    public String getMethodExecStatsReport() {
        StringBuilder sb = new StringBuilder().append(" Method                         Runs      Running   Errors   Avg          Total     \n").append("------------------------------ --------- --------- -------- ------------ -----------\n");
        this.getMethodExecStats().stream().sorted(Comparator.comparingDouble(MethodExecStats::getTotalTime).reversed()).forEach(x -> sb.append(String.format("%30s %9d %9d %9d %10dms %10dms\n", x.getMethod(), x.getRuns(), x.getRunning(), x.getErrors(), x.getAvgTime(), x.getTotalTime())));
        return sb.toString();
    }

    protected RestMethodParam[] findParams(MethodInfo mi, boolean isPreOrPost, UrlPathPattern pathPattern) throws ServletException {
        List<ClassInfo> pt = mi.getParamTypes();
        RestMethodParam[] rp = new RestMethodParam[pt.size()];
        PropertyStore ps = this.getPropertyStore();
        for (int i = 0; i < pt.size(); ++i) {
            ParamInfo mpi;
            ClassInfo t = pt.get(i);
            if (t.inner() != null) {
                Class c = t.inner();
                rp[i] = this.paramResolvers.get(c);
                if (rp[i] == null) {
                    rp[i] = RestParamDefaults.STANDARD_RESOLVERS.get(c);
                }
            }
            if ((mpi = mi.getParam(i)).hasAnnotation(Header.class)) {
                rp[i] = new RestParamDefaults.HeaderObject(mpi, ps);
            } else if (mpi.hasAnnotation(Attr.class)) {
                rp[i] = new RestParamDefaults.AttributeObject(mpi, ps);
            } else if (mpi.hasAnnotation(Query.class)) {
                rp[i] = new RestParamDefaults.QueryObject(mpi, ps);
            } else if (mpi.hasAnnotation(FormData.class)) {
                rp[i] = new RestParamDefaults.FormDataObject(mpi, ps);
            } else if (mpi.hasAnnotation(Path.class)) {
                rp[i] = new RestParamDefaults.PathObject(mpi, ps, pathPattern);
            } else if (mpi.hasAnnotation(Body.class)) {
                rp[i] = new RestParamDefaults.BodyObject(mpi, ps);
            } else if (mpi.hasAnnotation(Request.class)) {
                rp[i] = new RestParamDefaults.RequestObject(mpi, ps);
            } else if (mpi.hasAnnotation(Response.class)) {
                rp[i] = new RestParamDefaults.ResponseObject(mpi, ps);
            } else if (mpi.hasAnnotation(ResponseHeader.class)) {
                rp[i] = new RestParamDefaults.ResponseHeaderObject(mpi, ps);
            } else if (mpi.hasAnnotation(ResponseStatus.class)) {
                rp[i] = new RestParamDefaults.ResponseStatusObject(t);
            } else if (mpi.hasAnnotation(HasFormData.class)) {
                rp[i] = new RestParamDefaults.HasFormDataObject(mpi);
            } else if (mpi.hasAnnotation(HasQuery.class)) {
                rp[i] = new RestParamDefaults.HasQueryObject(mpi);
            } else if (mpi.hasAnnotation(Method.class)) {
                rp[i] = new RestParamDefaults.MethodObject(mi, t, mpi);
            }
            if (rp[i] != null || isPreOrPost) continue;
            throw new RestServletException("Invalid parameter specified for method ''{0}'' at index position {1}", mi.inner(), i);
        }
        return rp;
    }

    protected RestCall createCall(HttpServletRequest req, HttpServletResponse res) {
        return new RestCall(this, req, res).logger(this.getCallLogger()).loggerConfig(this.getCallLoggerConfig());
    }

    public RestRequest createRequest(RestCall call) throws ServletException {
        return new RestRequest(call);
    }

    public RestResponse createResponse(RestCall call) throws ServletException {
        return new RestResponse(call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(HttpServletRequest r1, HttpServletResponse r2) throws ServletException, IOException {
        RestCall call = this.createCall(r1, r2);
        if (this.call.get() != null) {
            System.err.println("WARNING:  Thread-local call object was not cleaned up from previous request.  " + this + ", thread=[" + Thread.currentThread().getId() + "]");
        }
        this.call.set(call);
        try {
            this.checkForInitException();
            if (this.pathPattern.hasVars() && this.getParentContext() == null) {
                String sp = call.getServletPath();
                String pi = call.getPathInfoUndecoded();
                UrlPathInfo upi2 = new UrlPathInfo(pi == null ? sp : sp + (String)pi);
                UrlPathPatternMatch uppm = this.pathPattern.match(upi2);
                if (uppm != null && !uppm.hasEmptyVars()) {
                    call.addPathVars(uppm.getVars());
                    call.request((HttpServletRequest)new OverrideableHttpServletRequest(call.getRequest()).pathInfo(StringUtils.nullIfEmpty(StringUtils.urlDecode(uppm.getSuffix()))).servletPath(uppm.getPrefix()));
                } else {
                    call.debug(this.isDebug(call)).status(404).finish();
                    return;
                }
            }
            String pi = call.getPathInfoUndecoded();
            if (!this.childResources.isEmpty() && pi != null && !pi.equals("/")) {
                for (RestContext rc : this.getChildResources().values()) {
                    UrlPathPattern upp = rc.pathPattern;
                    UrlPathPatternMatch uppm = upp.match(call.getUrlPathInfo());
                    if (uppm == null) continue;
                    if (!uppm.hasEmptyVars()) {
                        call.addPathVars(uppm.getVars());
                        OverrideableHttpServletRequest childRequest = new OverrideableHttpServletRequest(call.getRequest()).pathInfo(StringUtils.nullIfEmpty(StringUtils.urlDecode(uppm.getSuffix()))).servletPath(call.getServletPath() + uppm.getPrefix());
                        rc.execute((HttpServletRequest)childRequest, call.getResponse());
                    } else {
                        call.debug(this.isDebug(call)).status(404).finish();
                    }
                    return;
                }
            }
            if (this.isDebug(call)) {
                call.debug(true);
            }
            this.startCall(call);
            this.createRequest(call);
            this.createResponse(call);
            StaticFile r = null;
            if (call.getPathInfoUndecoded() != null) {
                String p = call.getPathInfoUndecoded().substring(1);
                if (this.isStaticFile(p)) {
                    r = this.getStaticFile(p);
                    if (!r.exists()) {
                        call.output(null);
                        r = null;
                    }
                } else if (p.equals("favicon.ico")) {
                    call.output(null);
                }
            }
            if (r != null) {
                call.status(200);
                call.output(r);
            } else {
                try {
                    this.findMethod(call).invoke(call);
                }
                catch (NotFound e) {
                    if (call.getStatus() == 0) {
                        call.status(404);
                    }
                    this.handleNotFound(call);
                }
            }
            if (call.hasOutput()) {
                this.handleResponse(call);
            }
        }
        catch (Throwable e) {
            this.handleError(call, this.convertThrowable(e));
        }
        finally {
            this.clearState();
        }
        call.finish();
        this.finishCall(call);
    }

    private RestMethodContext findMethod(RestCall call) throws Throwable {
        int mrc;
        String m = call.getMethod();
        int rc = 0;
        if (this.methodMap.containsKey(m)) {
            for (RestMethodContext mc : this.methodMap.get(m)) {
                mrc = mc.match(call);
                if (mrc == 2) {
                    return mc;
                }
                rc = Math.max(rc, mrc);
            }
        }
        if (this.methodMap.containsKey("*")) {
            for (RestMethodContext mc : this.methodMap.get("*")) {
                mrc = mc.match(call);
                if (mrc == 2) {
                    return mc;
                }
                rc = Math.max(rc, mrc);
            }
        }
        if (rc == 0) {
            for (RestMethodContext mc : this.methods) {
                if (mc.getPathPattern().endsWith("/*") || (mrc = mc.match(call)) != 2) continue;
                throw new MethodNotAllowed();
            }
        }
        if (rc == 1) {
            throw new PreconditionFailed("Method ''{0}'' not found on resource on path ''{1}'' with matching matcher.", m, call.getPathInfo());
        }
        throw new NotFound();
    }

    private boolean isDebug(RestCall call) {
        Enablement e = null;
        RestMethodContext mc = call.getRestMethodContext();
        if (mc != null) {
            e = mc.getDebug();
        }
        if (e == null) {
            e = this.getDebug();
        }
        if (e == Enablement.TRUE) {
            return true;
        }
        if (e == Enablement.FALSE) {
            return false;
        }
        if (e == Enablement.PER_REQUEST) {
            return "true".equalsIgnoreCase(call.getRequest().getHeader("X-Debug"));
        }
        return false;
    }

    public void handleResponse(RestCall call) throws IOException, HttpException, NotImplemented {
        RestRequest req = call.getRestRequest();
        RestResponse res = call.getRestResponse();
        for (ResponseHandler h : this.getResponseHandlers()) {
            if (!h.handle(req, res)) continue;
            return;
        }
        Object output = res.getOutput();
        throw new NotImplemented("No response handlers found to process output of type '" + (output == null ? null : output.getClass().getName()) + "'");
    }

    public Throwable convertThrowable(Throwable t) {
        ClassInfo ci = ClassInfo.ofc(t);
        if (ci.is(InvocationTargetException.class)) {
            t = ((InvocationTargetException)t).getTargetException();
            ci = ClassInfo.ofc(t);
        }
        if (ci.is(HttpRuntimeException.class)) {
            t = ((HttpRuntimeException)t).getInner();
            ci = ClassInfo.ofc(t);
        }
        if (ci.isChildOf(RestException.class) || ci.hasAnnotation(Response.class)) {
            return t;
        }
        if (t instanceof ParseException || t instanceof InvalidDataConversionException) {
            return new BadRequest(t);
        }
        String n = t.getClass().getName();
        if (n.contains("AccessDenied") || n.contains("Unauthorized")) {
            return new Unauthorized(t);
        }
        if (n.contains("Empty") || n.contains("NotFound")) {
            return new NotFound(t);
        }
        return t;
    }

    public void handleNotFound(RestCall call) throws Exception {
        String onPath;
        String pathInfo = call.getPathInfo();
        String methodUC = call.getMethod();
        int rc = call.getStatus();
        String string = onPath = pathInfo == null ? " on no pathInfo" : String.format(" on path '%s'", pathInfo);
        if (rc == 404) {
            throw new NotFound("Method ''{0}'' not found on resource with matching pattern{1}.", methodUC, onPath);
        }
        if (rc == 412) {
            throw new PreconditionFailed("Method ''{0}'' not found on resource{1} with matching matcher.", methodUC, onPath);
        }
        if (rc == 405) {
            throw new MethodNotAllowed("Method ''{0}'' not found on resource{1}.", methodUC, onPath);
        }
        throw new ServletException("Invalid method response: " + rc);
    }

    public synchronized void handleError(RestCall call, Throwable e) throws IOException {
        call.exception(e);
        if (call.isDebug()) {
            e.printStackTrace();
        }
        int occurrence = this.getStackTraceOccurrence(e);
        int code = 500;
        ClassInfo ci = ClassInfo.ofc(e);
        Response r = ci.getLastAnnotation(Response.class);
        if (r != null && r.code().length > 0) {
            code = r.code()[0];
        }
        RestException e2 = (e instanceof RestException ? (RestException)e : new RestException(e, code)).setOccurrence(occurrence);
        HttpServletRequest req = call.getRequest();
        HttpServletResponse res = call.getResponse();
        Throwable t = null;
        if (e instanceof HttpRuntimeException) {
            t = ((HttpRuntimeException)e).getInner();
        }
        if (t == null) {
            t = e2.getRootCause();
        }
        if (t != null) {
            res.setHeader("Exception-Name", StringUtils.stripInvalidHttpHeaderChars(t.getClass().getName()));
            res.setHeader("Exception-Message", StringUtils.stripInvalidHttpHeaderChars(t.getMessage()));
        }
        try {
            res.setContentType("text/plain");
            res.setHeader("Content-Encoding", "identity");
            res.setStatus(e2.getStatus());
            PrintWriter w = null;
            try {
                w = res.getWriter();
            }
            catch (IllegalStateException x) {
                w = new PrintWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), IOUtils.UTF8));
            }
            try (PrintWriter w2 = w;){
                String httpMessage = RestUtils.getHttpResponseText(e2.getStatus());
                if (httpMessage != null) {
                    w2.append("HTTP ").append(String.valueOf(e2.getStatus())).append(": ").append(httpMessage).append("\n\n");
                }
                if (this.isRenderResponseStackTraces()) {
                    e.printStackTrace(w2);
                } else {
                    w2.append(e2.getFullStackMessage(true));
                }
            }
        }
        catch (Exception e1) {
            req.setAttribute("Exception", (Object)e1);
        }
    }

    public Map<String, Object> getSessionObjects(RestCall call) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("req", call.getRequest());
        m.put("res", call.getResponse());
        return m;
    }

    protected void startCall(RestCall call) {
        for (int i = 0; i < this.startCallMethods.length; ++i) {
            RestContext.startOrFinish(this.resource, this.startCallMethods[i], this.startCallMethodParams[i], call.getRequest(), call.getResponse());
        }
    }

    protected void preCall(RestCall call) throws HttpException {
        for (int i = 0; i < this.preCallMethods.length; ++i) {
            RestContext.preOrPost(this.resource, this.preCallMethods[i], this.preCallMethodParams[i], call);
        }
    }

    protected void postCall(RestCall call) throws HttpException {
        for (int i = 0; i < this.postCallMethods.length; ++i) {
            RestContext.preOrPost(this.resource, this.postCallMethods[i], this.postCallMethodParams[i], call);
        }
    }

    private static void preOrPost(Object resource, MethodInvoker m, RestMethodParam[] mp, RestCall call) throws HttpException {
        if (m != null) {
            Object[] args = new Object[mp.length];
            for (int i = 0; i < mp.length; ++i) {
                try {
                    args[i] = mp[i].resolve(call.getRestRequest(), call.getRestResponse());
                    continue;
                }
                catch (Exception e) {
                    throw HttpRuntimeException.toHttpException(e, BadRequest.class, "Invalid data conversion.  Could not convert {0} ''{1}'' to type ''{2}'' on method ''{3}.{4}''.", mp[i].getParamType().name(), mp[i].getName(), mp[i].getType(), m.getDeclaringClass().getName(), m.getName());
                }
            }
            try {
                m.invoke(resource, args);
            }
            catch (Exception e) {
                throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
            }
        }
    }

    protected void finishCall(RestCall call) {
        for (int i = 0; i < this.endCallMethods.length; ++i) {
            RestContext.startOrFinish(this.resource, this.endCallMethods[i], this.endCallMethodParams[i], call.getRequest(), call.getResponse());
        }
    }

    private static void startOrFinish(Object resource, MethodInvoker m, Class<?>[] p, HttpServletRequest req, HttpServletResponse res) throws HttpException, InternalServerError {
        if (m != null) {
            Object[] args = new Object[p.length];
            for (int i = 0; i < p.length; ++i) {
                if (p[i] == HttpServletRequest.class) {
                    args[i] = req;
                    continue;
                }
                if (p[i] != HttpServletResponse.class) continue;
                args[i] = res;
            }
            try {
                m.invoke(resource, args);
            }
            catch (Exception e) {
                throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
            }
        }
    }

    public RestContext postInit() throws ServletException {
        for (int i = 0; i < this.postInitMethods.length; ++i) {
            this.postInitOrDestroy(this.resource, this.postInitMethods[i], this.postInitMethodParams[i]);
        }
        for (RestContext childContext : this.childResources.values()) {
            childContext.postInit();
        }
        return this;
    }

    public RestContext postInitChildFirst() throws ServletException {
        for (RestContext childContext : this.childResources.values()) {
            childContext.postInitChildFirst();
        }
        for (int i = 0; i < this.postInitChildFirstMethods.length; ++i) {
            this.postInitOrDestroy(this.resource, this.postInitChildFirstMethods[i], this.postInitChildFirstMethodParams[i]);
        }
        return this;
    }

    private void postInitOrDestroy(Object r, MethodInvoker m, Class<?>[] p) {
        if (m != null) {
            Object[] args = new Object[p.length];
            for (int i = 0; i < p.length; ++i) {
                if (p[i] == RestContext.class) {
                    args[i] = this;
                    continue;
                }
                if (p[i] == RestContextBuilder.class) {
                    args[i] = this.builder;
                    continue;
                }
                if (p[i] != ServletConfig.class) continue;
                args[i] = this.builder.inner;
            }
            try {
                m.invoke(r, args);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException && ClassInfo.of(e).hasAnnotation(Response.class)) {
                    throw (RuntimeException)e;
                }
                throw new InternalServerError(e);
            }
        }
    }

    protected void destroy() {
        for (int i = 0; i < this.destroyMethods.length; ++i) {
            try {
                this.postInitOrDestroy(this.resource, this.destroyMethods[i], this.destroyMethodParams[i]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (RestContext r : this.childResources.values()) {
            r.destroy();
            if (!(r.resource instanceof Servlet)) continue;
            ((Servlet)r.resource).destroy();
        }
    }

    public RestRequest getRequest() {
        RestCall rc = this.call.get();
        return rc == null ? null : rc.getRestRequest();
    }

    public RestResponse getResponse() {
        RestCall rc = this.call.get();
        return rc == null ? null : rc.getRestResponse();
    }

    public ResponseBeanMeta getResponseBeanMeta(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ResponseBeanMeta rbm = this.responseBeanMetas.get(c);
        if (rbm == null) {
            rbm = ResponseBeanMeta.create(c, this.serializers.getPropertyStore());
            if (rbm == null) {
                rbm = ResponseBeanMeta.NULL;
            }
            this.responseBeanMetas.put(c, rbm);
        }
        if (rbm == ResponseBeanMeta.NULL) {
            return null;
        }
        return rbm;
    }

    Enablement getDebug() {
        return this.debug;
    }

    void clearState() {
        this.call.remove();
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap().a("allowBodyParam", this.allowBodyParam).a("allowedMethodHeader", this.allowedMethodHeaders).a("allowedMethodParams", this.allowedMethodParams).a("allowedHeaderParams", this.allowedHeaderParams).a("clientVersionHeader", this.clientVersionHeader).a("consumes", this.consumes).a("infoProvider", this.infoProvider).a("logger", this.logger).a("paramResolvers", this.paramResolvers).a("parsers", this.parsers).a("partParser", this.partParser).a("partSerializer", this.partSerializer).a("produces", this.produces).a("properties", this.properties).a("renderResponseStackTraces", this.renderResponseStackTraces).a("reqHeaders", this.reqHeaders).a("resHeaders", this.resHeaders).a("resourceResolver", this.resourceResolver).a("responseHandlers", this.responseHandlers).a("serializers", this.serializers).a("staticFileResponseHeaders", this.staticFileResponseHeaders).a("staticFiles", this.staticFiles).a("uriAuthority", this.uriAuthority).a("uriContext", this.uriContext).a("uriRelativity", (Object)this.uriRelativity).a("uriResolution", (Object)this.uriResolution).a("useClasspathResourceCaching", this.useClasspathResourceCaching));
    }

    static class MethodMapBuilder {
        TreeMap<String, TreeSet<RestMethodContext>> map = new TreeMap();
        Set<RestMethodContext> set = ASet.of(new RestMethodContext[0]);

        MethodMapBuilder() {
        }

        MethodMapBuilder add(String httpMethodName, RestMethodContext mc) {
            if (!this.map.containsKey(httpMethodName = httpMethodName.toUpperCase())) {
                this.map.put(httpMethodName, new TreeSet());
            }
            this.map.get(httpMethodName).add(mc);
            this.set.add(mc);
            return this;
        }

        Map<String, List<RestMethodContext>> getMap() {
            AMap m = AMap.of();
            for (Map.Entry<String, TreeSet<RestMethodContext>> e : this.map.entrySet()) {
                m.put(e.getKey(), AList.of((Collection)e.getValue()));
            }
            return m.unmodifiable();
        }

        List<RestMethodContext> getList() {
            return AList.of(this.set).unmodifiable();
        }
    }

    public static final class Null
    extends RestContext {
        public Null(RestContextBuilder builder) throws Exception {
            super(builder);
        }
    }
}

