/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.basic;

import org.apache.jena.graph.Node;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFCountingBase;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.system.progress.MonitorOutput;
import org.apache.jena.system.progress.ProgressMonitor;
import org.apache.jena.system.progress.ProgressMonitorOutput;
import org.apache.jena.tdb2.loader.base.LoaderBase;
import org.apache.jena.tdb2.loader.base.LoaderOps;

public class LoaderBasic
extends LoaderBase {
    private static int DataTickPoint = 100000;
    private static int DataSuperTick = 10;
    private final StreamRDFCounting dest;
    private final StreamRDF baseDest;

    public LoaderBasic(DatasetGraph dsg, Node graphName, MonitorOutput output) {
        super(dsg, graphName, output);
        this.baseDest = LoaderOps.toNamedGraph(StreamRDFLib.dataset((DatasetGraph)dsg), graphName);
        this.dest = new StreamRDFCountingBase(this.baseDest);
    }

    @Override
    protected boolean bulkUseTransaction() {
        return true;
    }

    @Override
    public StreamRDF stream() {
        return this.dest;
    }

    @Override
    protected ProgressMonitor createProgressMonitor(MonitorOutput output) {
        return ProgressMonitorOutput.create((MonitorOutput)output, (String)"<unset>", (long)DataTickPoint, (int)DataSuperTick);
    }

    @Override
    public long countTriples() {
        return this.dest.countTriples();
    }

    @Override
    public long countQuads() {
        return this.dest.countQuads();
    }
}

