/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.shaded.json4s;

import java.io.StringReader;
import java.io.Writer;
import org.apache.livy.shaded.json4s.ParserUtil;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class ParserUtil$ {
    public static final ParserUtil$ MODULE$;
    private final char org$json4s$ParserUtil$$EOF;
    private final BigDecimal BrokenDouble;

    static {
        new ParserUtil$();
    }

    public char org$json4s$ParserUtil$$EOF() {
        return this.org$json4s$ParserUtil$$EOF;
    }

    public String quote(String s) {
        return this.quote(s, new ParserUtil.StringBuilderAppender(new StringBuilder())).toString();
    }

    public Writer quote(String s, Writer writer) {
        return this.quote(s, new ParserUtil.StringWriterAppender(writer));
    }

    private <T> T quote(String s, ParserUtil.StringAppender<T> appender) {
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            T t;
            Predef$ predef$ = Predef$.MODULE$;
            char c = StringOps$.MODULE$.apply$extension(s, i);
            if (c == '\"') {
                t = appender.append("\\\"");
                continue;
            }
            if (c == '\\') {
                t = appender.append("\\\\");
                continue;
            }
            if (c == '\b') {
                t = appender.append("\\b");
                continue;
            }
            if (c == '\f') {
                t = appender.append("\\f");
                continue;
            }
            if (c == '\n') {
                t = appender.append("\\n");
                continue;
            }
            if (c == '\r') {
                t = appender.append("\\r");
                continue;
            }
            if (c == '\t') {
                t = appender.append("\\t");
                continue;
            }
            if (c >= '\u0000' && c <= '\u001f' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                Predef$ predef$2 = Predef$.MODULE$;
                t = appender.append(new StringOps("\\u%04x").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)})));
                continue;
            }
            t = appender.append(((Object)BoxesRunTime.boxToCharacter((char)c)).toString());
        }
        return appender.subj();
    }

    public String unquote(String string) {
        return this.unquote(new ParserUtil.Buffer(new StringReader(string), false));
    }

    public String unquote(ParserUtil.Buffer buf) {
        buf.eofIsFailure_$eq(true);
        buf.mark();
        char c = buf.next();
        while (c != '\"') {
            if (c == '\\') {
                String s = this.unquote0$1(buf, buf.substring());
                buf.eofIsFailure_$eq(false);
                return s;
            }
            c = buf.next();
        }
        buf.eofIsFailure_$eq(false);
        return buf.substring();
    }

    private BigDecimal BrokenDouble() {
        return this.BrokenDouble;
    }

    public double parseDouble(String s) {
        BigDecimal d;
        BigDecimal bigDecimal = d = scala.package$.MODULE$.BigDecimal().apply(s);
        BigDecimal bigDecimal2 = this.BrokenDouble();
        if (!(bigDecimal != null ? !bigDecimal.equals(bigDecimal2) : bigDecimal2 != null)) {
            throw package$.MODULE$.error("Error parsing 2.2250738585072012e-308");
        }
        return d.doubleValue();
    }

    private final String unquote0$1(ParserUtil.Buffer buf, String base) {
        java.lang.StringBuilder s = new java.lang.StringBuilder(base);
        char c = '\\';
        while (c != '\"') {
            java.lang.StringBuilder stringBuilder;
            if (c == '\\') {
                char c2 = buf.next();
                switch (c2) {
                    default: {
                        stringBuilder = s.append('\\');
                        break;
                    }
                    case 'u': {
                        char[] chars = new char[]{buf.next(), buf.next(), buf.next(), buf.next()};
                        int codePoint = Integer.parseInt(new String(chars), 16);
                        stringBuilder = s.appendCodePoint(codePoint);
                        break;
                    }
                    case 't': {
                        stringBuilder = s.append('\t');
                        break;
                    }
                    case 'r': {
                        stringBuilder = s.append('\r');
                        break;
                    }
                    case 'n': {
                        stringBuilder = s.append('\n');
                        break;
                    }
                    case 'f': {
                        stringBuilder = s.append('\f');
                        break;
                    }
                    case 'b': {
                        stringBuilder = s.append('\b');
                        break;
                    }
                    case '/': {
                        stringBuilder = s.append('/');
                        break;
                    }
                    case '\\': {
                        stringBuilder = s.append('\\');
                        break;
                    }
                    case '\"': {
                        stringBuilder = s.append('\"');
                        break;
                    }
                }
            } else {
                stringBuilder = s.append(c);
            }
            c = buf.next();
        }
        return s.toString();
    }

    private ParserUtil$() {
        MODULE$ = this;
        this.org$json4s$ParserUtil$$EOF = (char)-1;
        this.BrokenDouble = scala.package$.MODULE$.BigDecimal().apply("2.2250738585072012e-308");
    }
}

