/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.repl;

import java.lang.reflect.Method;
import org.apache.livy.repl.SparkInterpreter;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import scala.Function0;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.BoxesRunTime;

public abstract class SparkContextInitializer$class {
    public static void createSparkContext(SparkInterpreter $this, SparkConf conf) {
        if (SparkContextInitializer$class.isSparkSessionPresent($this)) {
            SparkContextInitializer$class.spark2CreateContext($this, conf);
        } else {
            SparkContextInitializer$class.spark1CreateContext($this, conf);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void spark1CreateContext(SparkInterpreter $this, SparkConf conf) {
        $this.sparkContext_$eq(SparkContext$.MODULE$.getOrCreate(conf));
        Object sqlContext = null;
        if (conf.getBoolean("spark.repl.enableHiveContext", false)) {
            try {
                ClassLoader loader = (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SparkInterpreter $outer;

                    public final ClassLoader apply() {
                        return this.$outer.getClass().getClassLoader();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                if (loader.getResource("hive-site.xml") == null) {
                    $this.warn((Function0<Object>)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "livy.repl.enable-hive-context is true but no hive-site.xml found on classpath.";
                        }
                    });
                }
                sqlContext = Class.forName("org.apache.spark.sql.hive.HiveContext").getConstructor(SparkContext.class).newInstance($this.sparkContext());
                $this.info((Function0<Object>)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Created sql context (with Hive support).";
                    }
                });
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                sqlContext = Class.forName("org.apache.spark.sql.SQLContext").getConstructor(SparkContext.class).newInstance($this.sparkContext());
                $this.info((Function0<Object>)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Created sql context.";
                    }
                });
            }
        } else {
            sqlContext = Class.forName("org.apache.spark.sql.SQLContext").getConstructor(SparkContext.class).newInstance($this.sparkContext());
            $this.info((Function0<Object>)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Created sql context.";
                }
            });
        }
        $this.bind("sc", "org.apache.spark.SparkContext", $this.sparkContext(), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"@transient"})));
        $this.bind("sqlContext", sqlContext.getClass().getCanonicalName(), sqlContext, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"@transient"})));
        $this.execute("import org.apache.spark.SparkContext._");
        $this.execute("import sqlContext.implicits._");
        $this.execute("import sqlContext.sql");
        $this.execute("import org.apache.spark.sql.functions._");
    }

    private static void spark2CreateContext(SparkInterpreter $this, SparkConf conf) {
        Class<?> sparkClz = Class.forName("org.apache.spark.sql.SparkSession$");
        Object sparkObj = sparkClz.getField("MODULE$").get(null);
        Method builderMethod = sparkClz.getMethod("builder", new Class[0]);
        Object builder = builderMethod.invoke(sparkObj, new Object[0]);
        builder.getClass().getMethod("config", SparkConf.class).invoke(builder, conf);
        Object spark = null;
        String string = conf.get("spark.sql.catalogImplementation", "in-memory").toLowerCase();
        String string2 = "hive";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (BoxesRunTime.unboxToBoolean((Object)sparkClz.getMethod("hiveClassesArePresent", new Class[0]).invoke(sparkObj, new Object[0]))) {
                ClassLoader loader = (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SparkInterpreter $outer;

                    public final ClassLoader apply() {
                        return this.$outer.getClass().getClassLoader();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                if (loader.getResource("hive-site.xml") == null) {
                    $this.warn((Function0<Object>)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "livy.repl.enable-hive-context is true but no hive-site.xml found on classpath.";
                        }
                    });
                }
                builder.getClass().getMethod("enableHiveSupport", new Class[0]).invoke(builder, new Object[0]);
                spark = builder.getClass().getMethod("getOrCreate", new Class[0]).invoke(builder, new Object[0]);
                $this.info((Function0<Object>)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Created Spark session (with Hive support).";
                    }
                });
            } else {
                builder.getClass().getMethod("config", String.class, String.class).invoke(builder, "spark.sql.catalogImplementation", "in-memory");
                spark = builder.getClass().getMethod("getOrCreate", new Class[0]).invoke(builder, new Object[0]);
                $this.info((Function0<Object>)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Created Spark session.";
                    }
                });
            }
        } else {
            spark = builder.getClass().getMethod("getOrCreate", new Class[0]).invoke(builder, new Object[0]);
            $this.info((Function0<Object>)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Created Spark session.";
                }
            });
        }
        $this.sparkContext_$eq((SparkContext)spark.getClass().getMethod("sparkContext", new Class[0]).invoke(spark, new Object[0]));
        $this.bind("spark", spark.getClass().getCanonicalName(), spark, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"@transient"})));
        $this.bind("sc", "org.apache.spark.SparkContext", $this.sparkContext(), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"@transient"})));
        $this.execute("import org.apache.spark.SparkContext._");
        $this.execute("import spark.implicits._");
        $this.execute("import spark.sql");
        $this.execute("import org.apache.spark.sql.functions._");
    }

    private static boolean isSparkSessionPresent(SparkInterpreter $this) {
        Throwable throwable2;
        block2: {
            boolean bl;
            try {
                Class.forName("org.apache.spark.sql.SparkSession");
                bl = true;
            }
            catch (Throwable throwable2) {
                boolean bl2;
                Throwable throwable3 = throwable2;
                boolean bl3 = throwable3 instanceof ClassNotFoundException ? true : throwable3 instanceof NoClassDefFoundError;
                if (!bl3) break block2;
                bl = bl2 = false;
            }
            return bl;
        }
        throw throwable2;
    }

    public static void $init$(SparkInterpreter $this) {
    }
}

