/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.rpc.ReadIndexRequestBuilder;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;

class ReadIndexRequestDeserializer
implements MessageDeserializer<RpcRequests.ReadIndexRequest> {
    private final ReadIndexRequestBuilder msg;

    ReadIndexRequestDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.readIndexRequest();
    }

    @Override
    public Class<RpcRequests.ReadIndexRequest> klass() {
        return RpcRequests.ReadIndexRequest.class;
    }

    @Override
    public RpcRequests.ReadIndexRequest getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                String tmp = reader.readList("entriesList", MessageCollectionItemType.BYTE_BUFFER);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.entriesList((List<ByteBuffer>)((Object)tmp));
                reader.incrementState();
            }
            case 1: {
                String tmp = reader.readString("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.groupId(tmp);
                reader.incrementState();
            }
            case 2: {
                String tmp = reader.readString("peerId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.peerId(tmp);
                reader.incrementState();
            }
            case 3: {
                String tmp = reader.readString("serverId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.serverId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RpcRequests.ReadIndexRequest.class);
    }
}

